#!/bin/bash

if [ -n "$a_dc" ];then
   echo "DC is $a_dc"
else
   echo "$(date) Specify dc first! Exiting!."
   exit 1
fi

disk_queue_prod_flag="disk_queue_prod_flag.txt"
ipdd_prod_flag="ipdd_prod_flag.txt"

min_sm_count="500"

if [ -n "$LABELS_shard_id" ];then
    echo "$(date)================PROD================"
    echo "$(date) Try to get seachmap from $MOP_HOST. Label is specified in variable. LABELS_shard_id = $LABELS_shard_id"
    echo "$(date) Try to get seachmap for DISK from mop. Label is specified in variable. LABELS_shard_id = $LABELS_shard_id"

    if [ -f "$disk_queue_prod_flag" ]; then
        echo "$(date) $disk_queue_prod_flag already exists."
    else
        curl -f "$MOP_HOST/get-shards-for-consume?label=$LABELS_shard_id&host=$(hostname -f)&scope=disk&port=80&dc=$a_geo&full=true" > $1.disk
        if [ $? -ne 0 ];then
            echo "$(date) Cannot get sm from mop. Exiting!."
            exit 1
        fi

	l_disk_cnt=$(cat $1.disk | wc -l); 
	if [[ $l_disk_cnt -gt $min_sm_count ]]; then 
           echo "Check searchmap length is ok, lines is: $l_disk_cnt" 
	else
           echo "Check searchmap length is NOT ok, lines is: $l_disk_cnt"
           exit 1
	fi

    echo "$(date) Set up $disk_queue_prod_flag" > $disk_queue_prod_flag
    fi
 
    echo "$(date) Try to get seachmap for IPDD from mop. Label is specified in variable. LABELS_shard_id = $LABELS_shard_id"
    if [ -f "$ipdd_prod_flag" ]; then
        echo "$(date) $ipdd_prod_flag already exists."
    else
        curl -f "$MOP_HOST/get-shards-for-consume?label=$LABELS_shard_id&host=$(hostname -f)&scope=ipdd&port=80&dc=$a_geo&full=true" > $1.ipdd
        if [ $? -ne 0 ];then
            echo "$(date) Cannot get sm from mop. Exiting!."
            exit 1
        fi

        l_ipdd_cnt=$(cat $1.ipdd | wc -l); 
        if [[ $l_ipdd_cnt -gt $min_sm_count ]]; then 
           echo "Check searchmap length is ok, lines is: $l_ipdd_cnt"	   
        else
           echo "Check ipdd searchmap length is NOT ok, lines is: $l_ipdd_cnt"
           exit 1
        fi


    echo "$(date) Set up $ipdd_prod_flag" > $ipdd_prod_flag
    fi

else
   echo "$(date) Label doesnot specified! inum.txt does not exists. Exiting."
   exit 1
fi

#write two checked sm's
cat $1.disk > $1
cat $1.ipdd >> $1

echo "$(date) Clean up flags: $disk_queue_prod_flag $ipdd_prod_flag"

rm -f $disk_queue_prod_flag
rm -f $ipdd_prod_flag


