#!/bin/bash
source config.sh
source classpath.sh

portoctl run self/low command= isolate=false controllers[cpu]=true cpu_limit=1c cpu_period=10ms || true
portoctl run self/scripts command= isolate=false controllers[cpu]=true cpu_limit=0.3c || true

CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=$BSCONFIG_IDIR
export LD_PRELOAD=/usr/lib/libtcmalloc_minimal.so.4:$BSCONFIG_IDIR/libldpreload.so

GB=$((1024*1024*1024))
GB2=$((GB + GB))
GB3=$((GB + GB + GB))
XMX=$(portoctl get self memory_limit_total)
# more memory gap for instances due to PS-3771
XMX=$((XMX-GB3))

DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
GC_ARGS="-Xgcpolicy:gencon -verbose:gc -Xverbosegclog:/dev/shm/gc#.log,10,10000"
MEM_ARGS="-Xtune:virtualized
-XX:ActiveProcessorCount=5
-XcompilationThreads1
-XX:+IdleTuningGcOnIdle
-XX:IdleTuningMinIdleWaitTime=1
-XX:+IdleTuningCompactOnIdle
-Xcodecache8M
-Xcodecachetotal64M
-Xmn768M
-Xmx$XMX
-Xms$XMX
-Xmine256M
-Xmaxe1G
-Xmso128K
-Xmaxe1G
-Xmcrs64M
-Xgcthreads4
-Xconcurrentbackground3
-Xconcurrentlevel1
-Xgc:concurrentMark
-Xgc:concurrentScavengeBackground=3
-Xgc:concurrentScavenge
-Xmint0.3
-Xmaxt0.5
-Xmaxf0.15
-Xminf0.10
-Xaggressive
-Xgc:maxScavengeBeforeGlobal=100
-Xjit:scratchSpaceLimit=$((64*1024))
-Djdk.nio.maxCachedBufferSize=$((256*1024))
-Xsoftrefthreshold1000000000"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=.:bacchus \
    -DPORTO=1 \
    -cp $CLASSPATH \
    ru.yandex.bacchus.Bacchus \
    search_backend.conf \
    disk-search-backend-ljinx.conf \
    ocr-proxy.conf \
    peach.conf \
    kali.conf \
    consumer.conf \
    backpack_bacchus.conf

