#!/bin/bash
set -exo pipefail

source config.sh

STATUS_PORTS=(
# consumer
$CONSUMER_PORT
# kali
$((BSCONFIG_IPORT + 7))
# peach
$((BSCONFIG_IPORT + 4))
# ocr-proxy
$((BSCONFIG_IPORT + 5))
# ljinx
$LJINX_PORT
)

PING_PORTS=(
$SEARCH_PORT
$INDEXER_PORT
$CONSUMER_PORT
$((BSCONFIG_IPORT + 4))
$((BSCONFIG_IPORT + 5))
$((BSCONFIG_IPORT + 7))
$LJINX_PORT
)

WATCHDOG_ZOO_SHARD_ID=$((WATCHDOG_UID % 65534))
WATCHDOG_RESOURCE_ID=${WATCHDOG_UID}:${WATCHDOG_FILE_ID}

source check_search_backend_copyness_status.sh

end_date=$(expr $(date +%s) + 3600)
while true
do
    if [ $(date +%s) -ge $end_date ]
    then
        echo "$(date) Status script timed out"
        exit 1
    fi

    # Fast check clients, if any client is in any state except ACTIVE, exit 1
    # If /status is not available, probably service is not started yet,
    # just skip this check
    for status_port in ${STATUS_PORTS[@]}
    do
        if ! FAIL_FAST_EXIT_CODE=0 PORT=$status_port REQUEST_TIMEOUT=30 timeout 60 ./check_clients_status.sh
        then
            echo "$(date) Port $status_port /status check failed"
            exit 1
        fi
    done

    # Fast check, just sleep on failure
    failed=0
    for ping_port in ${PING_PORTS[@]}
    do
        if ! PORT=$ping_port REQUEST_TIMEOUT=30 timeout 60 ./check_http_status.sh
        then
            echo "$(date) Port $ping_port /ping check failed"
            failed=1
            break
        fi
    done

    if [ $failed -eq 1 ]
    then
        sleep 1
        continue
    fi

    WATCHDOG_VERSION=$(date +%s)000000
    code=$(curl -sm 120 -o /dev/null -w '%{http_code}' -H "ZooShardId: $WATCHDOG_ZOO_SHARD_ID" -H 'ZooQueue: disk_queue' "http://localhost:$((BSCONFIG_IPORT + 7))/?id=$WATCHDOG_FILE_ID&resource_id=$WATCHDOG_RESOURCE_ID&version=$WATCHDOG_VERSION&prefix=$WATCHDOG_UID&action=move_resource&service=disk_queue&zoo-queue-id=$WATCHDOG_VERSION&check-copyness=false&watchdog" || echo $?)
    if [ $code != 200 ]
    then
        echo "$(date) Indexation failed"
        sleep 1
        continue
    fi
    break
done

sleep 5
for status_port in ${STATUS_PORTS[@]}
do
    if ! PORT=$status_port REQUEST_TIMEOUT=30 timeout 60 ./check_clients_status.sh
    then
        echo "$(date) Port $status_port /status second check failed"
        exit 1
    fi
done

#failed=0
#for ping_port in ${PING_PORTS[@]}
#do
#    if ! PORT=$ping_port REQUEST_TIMEOUT=30 timeout 60 ./check_http_status.sh
#    then
#        echo "$(date) Port $ping_port /ping second check failed"
#        exit 1
#    fi
#done

exit 0

