#!/bin/bash
set -exo pipefail

source disk-config-base.sh

SEARCHMAP_PATH_TEMP=$SEARCHMAP_PATH.tmp
rm -f $SEARCHMAP_PATH_TEMP

case "$NANNY_SERVICE_ID" in
    disk-search-backend-yp-prod)
        # For mail-search-prod - download searchmap from mop.
        chmod +x ./get-searchmap.sh
        ./get-searchmap.sh $SEARCHMAP_PATH_TEMP
        ;;
    disk-search-backend-yp-bckp-prod)
        # For mail-search-prod - download searchmap from mop.
        chmod +x ./get-searchmap.sh
        ./get-searchmap.sh $SEARCHMAP_PATH_TEMP
        ;; 
    disk-search-backend-yp-fat-prod)
        # For mail-search-prod - download searchmap from mop.
        chmod +x ./get-searchmap.sh
        ./get-searchmap.sh $SEARCHMAP_PATH_TEMP
        ;;
    *)
        SEARCHMAP_PATH=$SEARCHMAP_PATH_TEMP ./getmap-rev.py
        ;;
esac

if [ ! -f $SEARCHMAP_PATH_TEMP ]; then
    >&2 echo "Temp searchmap was not founded on path $SEARCHMAP_PATH_TEMP. Exiting!"
    exit 1
fi

touch inum.txt.tmp
fgrep $HOSTNAME $SEARCHMAP_PATH_TEMP | grep -o 'iNum:[0-9]\+' | sort -u > inum.txt.tmp
inum_count=$(wc -l < inum.txt.tmp)
if [ $inum_count -ne 1 ]
then
    >&2 echo "Bad inum.txt:"
    >&2 echo "----BEGIN----"
    cat inum.txt.tmp >&2
    >&2 echo "-----END-----"
    exit 1
fi

fgrep $HOSTNAME $SEARCHMAP_PATH_TEMP | grep -o 'shards:[0-9]\+-[0-9]\+' | sort -u > shards.txt.tmp

if [ -x extra_searchmap.txt ]; then
	cat extra_searchmap.txt >> $SEARCHMAP_PATH_TEMP
fi

mv -f $SEARCHMAP_PATH_TEMP $SEARCHMAP_PATH
mv -f inum.txt.tmp inum.txt
mv -f shards.txt.tmp shards.txt

