#!/bin/bash
set -exo pipefail

source disk-config-base.sh
export MIN_CLUSTER_SIZE=10
export DEFAULT_COKEMULATOR="false"

export PUSHCLIENT_DEFAULT_TOPIC="/disk-search/disk-search-access-log"
export YT_ACCESS_LOG="/logs/diface-access.yt.log"
export PUSHCLIENT_DEFAULT_LOG_NAME=$YT_ACCESS_LOG

export RUN_CLASSES="ru.yandex.multistarter.MultiStarter ru.yandex.cokemulator.Cokemulator facemulator.conf ; ru.yandex.dispatcher.consumer.ConsumerServer -config diface_consumer.conf ; ru.yandex.ps.disk.search.Diface diface.conf"
case "$NANNY_SERVICE_ID" in
    *_face_prod)
        export HTTP_PORT=26551
        export MULCAGATE_HOST="storage.mail.yandex.net:10010"
        export AVA_HOST="http://avatars.mds.yandex.net"
        export COKEMULATOR_HOST="payments-proxy.pers.yandex.net"

        # noc bug - no traffic for producer balancer in myt passes, workaround
        export PRODUCER_INDEXING_HOST="disk-producer.search.yandex.net:19922"
        export STATUS_SCRIPT="./check_clients_status.sh"
        ;;
    *_face_test)
        # Need create this balancer
        export HTTP_PORT=26551
        export MIN_CLUSTER_SIZE=2
        export MULCAGATE_HOST="storage.stm.yandex.net:10010"
        export COKEMULATOR_HOST="localhost:82"

        export AVA_HOST="http://avatars.mdst.yandex.net"
        export PRODUCER_INDEXING_HOST="disk-producer-test.n.yandex-team.ru"
        export STATUS_SCRIPT="./check_clients_status.sh"
        export DEFAULT_COKEMULATOR="true"
        ;;

    *_facemulator_prod)
        export MULCAGATE_HOST="storage.mail.yandex.net:10010"
        export AVA_HOST="http://avatars.mds.yandex.net"
        export HTTP_PORT=82
        export RUN_CLASSES="ru.yandex.cokemulator.Cokemulator facemulator.conf"
        export STATUS_SCRIPT="./check_http_status.sh"
        ;;
    *_face_qa)
        export MULCAGATE_HOST="storage.mail.yandex.net:10010"
        export AVA_HOST="http://avatars.mds.yandex.net"
        export HTTP_PORT=26551
        source cache_classpath.sh
        export RUN_CLASSES="ru.yandex.multistarter.MultiStarter ru.yandex.cokemulator.Cokemulator facemulator.conf ; ru.yandex.ps.disk.search.Diface diface_qa.conf ; ru.yandex.ljinx.Ljinx ljinx.conf ; ru.yandex.msearch.Daemon -config cache_backend.conf ; ru.yandex.ps.disk.search.ExifInfoExtractor diface_exif.conf"
        export STATUS_SCRIPT="./check_clients_status.sh"
        export COKEMULATOR_HOST="localhost:82"
        # noc bug - no traffic for producer balancer in myt passes, workaround
        export PRODUCER_INDEXING_HOST="disk-producer.search.yandex.net:19922"
        ;;
esac

