#!/bin/sh
if [ -x gc_args.sh.overrides ]; then
	exec ./gc_args.sh.overrides
    exit 0;
fi

if [ "$MEM_LIMIT" != "" ]; then
    export MEMORY_LIMIT=$((MEM_LIMIT/100*80))
else
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.8)}')
fi

if [ "$MEMORY_LIMIT" = "0" ]; then
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["memory_guarantee"]' | awk '{print int($1*0.8)}')
fi

XMX=$MEMORY_LIMIT
XMS=$((XMX / 4))

export GC_ARGS="
-XX:ActiveProcessorCount=${CPU_CORES:-5}
-XX:+IgnoreUnrecognizedVMOptions
-XX:+HeapDumpOnOutOfMemoryError
-XX:HeapDumpPath=/cores
-XcompilationThreads1
-Xmx${XMX}
-Xms${XMS}
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseShenandoahGC
-XX:ConcGCThreads=1
-XX:ShenandoahGCMode=traversal
-XX:-ShenandoahAlwaysClearSoftRefs
-XX:ShenandoahAllocationThreshold=5
-XX:ShenandoahUncommitDelay=30000
-XX:ShenandoahGuaranteedGCInterval=30000
-XX:ShenandoahGarbageThreshold=10
-XX:+PrintCodeCache
-XX:ParallelGCThreads=7
-XX:MaxHeapFreeRatio=20
-XX:MinHeapFreeRatio=10
-XX:+UnlockDiagnosticVMOptions
-XX:+PrintGCDateStamps
-XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=2M
-Xlog:gc*:/dev/shm/gclogs/gc.log
"