#!/bin/bash
set -exo pipefail

source diface_config.sh
source classpath.sh

CORE_DIR="/coredumps"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export LD_LIBRARY_PATH="$BSCONFIG_IDIR:$BSCONFIG_IDIR/diface:$BSCONFIG_IDIR/face_model:$BSCONFIG_IDIR/diface_qa_cache"


CPU_CORES_CORRECTION=${CPU_CORES_CORRECTION:-"0.2"}
if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
fi

source diface_gc_args.sh
#MEM_ARGS="-Xms1G -Xmx$XMX -Xmn384M -Xmaxf0.4 -Xminf0.2 -Xmine256M -Xmaxe1G -Xmint0.03"
#GC_ARGS="-Xgcpolicy:balanced -verbose:gc -Xverbosegclog:/logs/gc#.log,10,10000"
DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"

exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=$LD_LIBRARY_PATH \
    -cp $CLASSPATH \
    $RUN_CLASSES

