package ru.yandex.ps.disk.search;

import java.util.logging.Logger;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;

public abstract class AbstractDifaceContext implements DifaceContext {
    protected final double minClusterSize;
    protected final double clusterThreshold;
    protected final long version;
    protected final ProxySession session;
    protected final Diface server;
    protected final boolean debug;
    protected final FaceStat stat;
    protected final boolean cokemulator;
    protected final boolean fallbackOnOriginal;
    protected final boolean checkDimensions;
    protected final double dimensionsRatioEps;

    protected AbstractDifaceContext(
        final Diface server,
        final ProxySession session)
        throws BadRequestException
    {
        this.server = server;
        this.session = session;
        this.debug = session.params().getBoolean("debug", false);
        this.minClusterSize =
            session.params().getDouble(
                "min_cluster_size",
                server.config().minClusterSize());
        this.clusterThreshold =
            session.params().getDouble(
                "cluster_threshold",
                server.config().clusterThreshold());

        this.fallbackOnOriginal = session.params().getBoolean(
            "fallback-original",
            server.config().tryOrigAfterPreviewFail());
        this.checkDimensions = session.params().getBoolean(
            "check-dimensions",
            server.config().checkDimensions());
        this.dimensionsRatioEps =
            session.params().getDouble(
                "dimentions-ration-thrsh",
                server.config().checkDimensionsThreshold());
        long version = session.params().getLong("zoo-queue-id", 0L);
        this.version = session.params().getLong("version", version);
        cokemulator =
            session.params().getBoolean(
                "cokemulator",
                server.config().defaultCokemulator());
        this.stat = new FaceStat();
    }

    public boolean tryOriginalOnPreviewFailed() {
        return fallbackOnOriginal;
    }

    @Override
    public long version() {
        return version;
    }

    @Override
    public Logger logger() {
        return session.logger();
    }

    @Override
    public boolean debug() {
        return debug;
    }

    @Override
    public double minClusterSize() {
        return minClusterSize;
    }

    @Override
    public double clusterThreshold() {
        return clusterThreshold;
    }

    public Diface server() {
        return server;
    }

    @Override
    public FaceStat stat() {
        return stat;
    }

    @Override
    public boolean cokemulator() {
        return cokemulator;
    }

    @Override
    public ProxySession session() {
        return session;
    }

    public boolean checkDimensions() {
        return checkDimensions;
    }

    public double dimensionsRatioEps() {
        return dimensionsRatioEps;
    }
}
