package ru.yandex.ps.disk.search;

public class AgeThreshold extends DpThreshold {
    private final double age;

    public AgeThreshold(
        final double threshold,
        final double age,
        final String name,
        final int index)
    {
        super(threshold, name, index);
        this.age = age;
    }

    @Override
    public ThresholdVerdict apply(final Face face1, final Face face2, final DpCache cache) {
        boolean check = face1.age() <= age || face2.age() <= age;
        if (!check) {
            return ThresholdVerdict.CONTINUE;
        }

        return super.apply(face1, face2, cache);
    }

    @Override
    public String toString() {
        return name() + "(" + threshold() + ",age=" + age + ")";
    }
}
