package ru.yandex.ps.disk.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class Cluster implements JsonValue {
    public static final double THRESHOLD = 0.65;
    public static final double THRESHOLD2 = 0.65;

    private List<Face> faces;
    private Set<String> faceIds;
    private final Map<String, Integer> names = new LinkedHashMap<>();
    private long[] meanVectorSum;
    private byte[] meanVector;
    private final String id;
    private final String firstFaceId;
    private final long version;

    Cluster(final String id, final String firstFaceId, final long version) {
        faces = new ArrayList<>();
        faceIds = new LinkedHashSet<>();
        this.id = id;
        this.version = version;
        this.firstFaceId = firstFaceId;
    }

    public String name() {
        if (names.isEmpty()) {
            return null;
        }

        int max = 0;
        int total = 0;
        String name = null;
        for (Map.Entry<String, Integer> entry: names.entrySet()) {
            if (entry.getValue() > max) {
                max = entry.getValue();
                name = entry.getKey();
            }

            total += entry.getValue();
        }

        if (max > total / 2.0) {
            return name;
        }

        return null;
    }

    public Map<String, Integer> names() {
        return names;
    }

    public Cluster name(final String name) {
        this.names.put(name, this.names.getOrDefault(name, 0) + 1);
        return this;
    }

    public List<Face> faces() {
        return faces;
    }

    public String id() {
        return id;
    }

    public long version() {
        return version;
    }

    //    public double dp(final Face face) {
//        return face.dotProduct(meanVector);
//    }
//
//    public double dp(final Cluster cluster) {
//        double minDp = 10;
////            double maxDp = -10;
//        double sum = 0;
//        int count = 0;
//        ArrayList<Face> all = new ArrayList<>(faces);
//        all.addAll(cluster.faces);
//        for (int i = 0; i < all.size(); i++) {
//            for (int j = 0; j < all.size(); j++) {
//                if (i == j) {
//                    continue;
//                }
//                Face f1 = all.get(i);
//                Face f2 = all.get(j);
////            for (ru.yandex.ps.disk.search.Face face: faces) {
////                for (ru.yandex.ps.disk.search.Face f2: cluster.faces) {
//                double dp = f1.dotProduct(f2);
////                    sum += dp;
////                    count++;
//                if (dp < minDp) {
//                    minDp = dp;
//                }
////                    if (dp > maxDp) {
////                        maxDp = dp;
////                    }
//            }
//        }
//        if (minDp != 10) {
//            return minDp;
//        }
//        return -10;
////            return maxDp;
////            return ru.yandex.ps.disk.search.Face.dotProduct(meanVector, cluster.meanVector);
////            return sum / count;
//    }

    public double disp(final Cluster cluster) {
//            double sum = 0;
//            double powSum = 0;
//            int count = 0;
        double maxDp = 0;
        ArrayList<Face> all = new ArrayList<>(faces);
        all.addAll(cluster.faces);
        for (int i = 0; i < all.size(); i++) {
            for (int j = 0; j < all.size(); j++) {
                if (i == j) {
                    continue;
                }
                Face f1 = all.get(i);
                Face f2 = all.get(j);
                double dp = f1.dotProduct(f2);
                dp = 1 - Math.abs(dp);
                if (dp > maxDp) {
                    maxDp = dp;
                }
//                    sum += dp;
//                    powSum += dp * dp;
//                    count++;
            }
        }
        return maxDp;
//            double med = sum / count;
//            double powMed = powSum / count;
//            return powMed - med * med;
    }

//    public boolean matches(final Face face) {
//        if (face.dotProduct(meanVector) > THRESHOLD) {
//            return true;
//        }
//        return false;
//    }

    public boolean tupoMatches(final Face face) {
        for (Face f: faces) {
            if (face.dotProduct(f) > THRESHOLD) {
                return true;
            }
        }
        return false;
    }

    public boolean matches(final Cluster other) {
        if (Face.dotProduct(meanVector, other.meanVector) > THRESHOLD2) {
            return true;
        }
        return false;
    }

    public void merge(final Cluster other) {
        for (Face face: other.faces) {
            addFace(face);
        }
    }

    public static byte clamp(final long i) {
        return (byte) Math.max(-127, Math.min(127, i));
    }

    public void addFace(final Face face) {
        if (faceIds.contains(face.faceId())) {
            return;
        }
        faces.add(face);
        faceIds.add(face.faceId());

        if (face.name() != null) {
            this.name(face.name());
        }

        face.cluster(this);
        byte[] v = face.vector();
        int faceCount = faces.size();
        if (meanVectorSum == null || meanVectorSum.length < v.length) {
            meanVectorSum = new long[v.length];
            meanVector = new byte[v.length];
        }
        for (int i = 0; i < v.length; i++) {
            meanVectorSum[i] += v[i];
            meanVector[i] = clamp(meanVectorSum[i] / faceCount);
        }
/*
        if (faces.size() > 1) {
            for (int i = 0; i < faces.size(); i++) {
                ru.yandex.ps.disk.search.Face f = faces.get(i);
                if (f == face) {
                    continue;
                }
                double dp = f.dotProduct(face);
                if (dp < minDp) {
                    minDp = dp;
                }
            }
//                for (int i = 0; i < faces.size(); i++) {
//                    for (int j = 0; j < faces.size(); j++) {
//                        if (i == j) {
//                            continue;
//                        }
//                        double dp = faces.get(i).dotProduct(faces.get(j));
//                        if (minDp > dp) {
//                            minDp = dp;
//                        }
//                    }
//                }
        }
*/
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("id");
        writer.value("face_cluster_" + id);
        writer.key(FaceBackendFields.FACECLUSTER_ID.stored());
        writer.value(id);
        writer.key(FaceBackendFields.FACECLUSTER_VERSION.stored());
        writer.value(version);
        writer.key(FaceBackendFields.FACECLUSTER_FIRST_FACE.stored());
        writer.value(firstFaceId);
        writer.key(DiskBackendFields.TYPE.stored());
        writer.value("face_cluster");
        writer.key("face_cluster_suggest_name");
        writer.value(name());
        writer.key("face_cluster_suggest_names");
        writer.value(namesAsString());

        writer.endObject();
    }


    public static Cluster parseFromBackend(
        final JsonObject jsonObj)
        throws JsonException
    {
        JsonMap map = jsonObj.asMap();

        String clusterId = map.getString(FaceBackendFields.FACECLUSTER_ID.stored());
        String firstFaceId = map.getString(FaceBackendFields.FACECLUSTER_FIRST_FACE.stored(), "");
        long version = map.getLong(FaceBackendFields.FACECLUSTER_VERSION.stored());
        return new Cluster(clusterId, firstFaceId, version);
    }

    public String namesAsString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Integer> entry: names.entrySet()) {
            sb.append(entry.getKey());
            sb.append(':');
            sb.append(entry.getValue());
            sb.append(',');
        }

        return sb.toString();
    }
    @Override
    public String toString() {
        return "Cluster{" +
            "faces=" + faces.size() +
            ", id='" + id + '\'' +
            ", first_face_id='" + firstFaceId + '\'' +
            ", name=" + name() +
            ", names=" + namesAsString() +
            ", version=" + version +
            '}';
    }
}
