package ru.yandex.ps.disk.search;

import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonType;

public class DiskBackendDataCallback
    extends AbstractProxySessionCallback<JsonObject>
{
    private final DifaceRequestContext context;
    public DiskBackendDataCallback(final DifaceRequestContext context) {
        super(context.session());

        this.context = context;
    }

    @Override
    public void completed(final JsonObject response) {
        context.session().response(HttpStatus.SC_OK, JsonType.HUMAN_READABLE.toString(response));
    }
}
