package ru.yandex.ps.disk.search;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.uri.CgiParams;

public class DiskDoc {
    private final String resourceId;
    private final String stid;
    private final String previewStid;
    private final int width;
    private final int height;
    private String mimetype;
    private int size;

    public DiskDoc(
        final JsonMap map)
        throws JsonException
    {
        this.resourceId = map.getString("resource_id");
        this.stid = map.getString("stid", null);
        this.previewStid = map.getString("preview_stid", null);
        this.width = map.getInt("width", -1);
        this.height = map.getInt("height", -1);
    }

    public DiskDoc(
        final String resourceId,
        final String stid,
        final String previewStid,
        final int width,
        final int height)
    {
        this.resourceId = resourceId;
        this.stid = stid;
        this.previewStid = previewStid;
        this.width = width;
        this.height = height;
    }

    public DiskDoc(
        final String resourceId,
        final String stid,
        final String previewStid,
        final int width,
        final int height,
        final String mimetype,
        final int size)
    {
        this.resourceId = resourceId;
        this.stid = stid;
        this.previewStid = previewStid;
        this.width = width;
        this.height = height;
        this.mimetype = mimetype;
        this.size = size;
    }

    public String resourceId() {
        return resourceId;
    }

    public String stid() {
        return stid;
    }

    public String previewStid() {
        return previewStid;
    }

    public int width() {
        return width;
    }

    public int height() {
        return height;
    }

    public static DiskDoc parseSingleDoc(
        final JsonMap map,
        final CgiParams params)
        throws BadRequestException, JsonException
    {
        String resId = map.getString("resource_id", null);
        if (resId == null) {
            resId = params.getString("resource_id");
        }

        String stid = map.getString("stid", null);
        if (stid == null) {
            stid = params.getString("stid", null);
        }

        String previewStid = map.getString("preview_stid", null);
        if (previewStid == null) {
            previewStid = params.getString("preview_stid", null);
            if (previewStid == null) {
                previewStid = stid;
            }
        }

        int width = map.getInt("width", -1);
        if (width < 0) {
            width = params.getInt("width", -1);
        }

        int height = map.getInt("height", -1);
        if (height < 0) {
            height = params.getInt("height", -1);
        }

        return new DiskDoc(resId, stid, previewStid, width, height);
    }

    public String mimetype() {
        return mimetype;
    }

    public int size() {
        return size;
    }
}
