package ru.yandex.ps.disk.search;

public class DpThreshold {
    private final double threshold;
    private final String name;
    private final int index;

    public DpThreshold(final double threshold, final String name, final int index) {
        this.threshold = threshold;
        this.name = name;
        this.index = index;
    }

    public ThresholdVerdict apply(final Face face1, final Face face2, final DpCache cache) {
        if (cache.neigbour(face1, face2, this)) {
            return ThresholdVerdict.YES;
        } else {
            return ThresholdVerdict.NO;
        }
    }

    public double threshold() {
        return threshold;
    }

    public String name() {
        return name;
    }

    public int index() {
        return index;
    }

    @Override
    public String toString() {
        return name + "(" + threshold + ")";
    }
}
