package ru.yandex.ps.disk.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;

public class ExtractOneHandler implements ProxyRequestHandler {
    private final Diface server;

    public ExtractOneHandler(final Diface server) {
        this.server = server;
    }

    @Override
    public void handle(
        final ProxySession session)
        throws HttpException, IOException
    {
        Context context = new Context(server, session);
        if (context.raw()) {
            boolean cokemulator = context.cokemulator();

            AsyncClient client = server.imageparserClient();
            HttpHost host = server.config().imageparserConfig().host();
            if (cokemulator) {
                client = server.cokemulatorClient();
                host = server.config().cokemulatorConfig().host();
            }

            FutureCallback<JsonObject> callback = new RawCallback(context);
            client = client.adjust(session.context());

            client.execute(
                host,
                server.createRequest(context.stid()),
                JsonAsyncTypesafeDomConsumerFactory.INSTANCE,
                session.listener().createContextGeneratorFor(client),
                callback);
        } else {
            server.extractFaces(
                context,
                context.stid(),
                new DiskDoc(context.stid(), context.stid(), context.stid(), 1, 1),
                new Callback(context));
        }
    }

    private static class Context extends AbstractDifaceContext {
        private final String stid;
        private final boolean hexifyVector;
        private final boolean raw;

        public Context(final Diface server, final ProxySession session) throws BadRequestException {
            super(server, session);

            stid = session.params().getString("stid");
            hexifyVector = session.params().getBoolean("hexify", true);
            raw = session.params().getBoolean("raw", false);
        }

        public String stid() {
            return stid;
        }

        public boolean hexifyVector() {
            return hexifyVector;
        }

        public boolean raw() {
            return raw;
        }
    }

    private static class Callback
        extends AbstractProxySessionCallback<List<Face>>
    {
        private final Context context;

        public Callback(final Context context) {
            super(context.session());

            this.context = context;
        }

        @Override
        public void completed(final List<Face> faces) {
            StringBuilder sb = new StringBuilder();
            try (JsonWriter writer = JsonType.HUMAN_READABLE.create(new StringBuilderWriter(sb))) {
                writer.startArray();
                writer.startObject();
                writer.key("stid");
                writer.value(context.stid());
                writer.key("faces");
                writer.startArray();
                for (Face face: faces) {
                    writer.startObject();
                    face.writeFields(writer, context.hexifyVector());
                    writer.key("dvector");
                    writer.value(Arrays.toString(face.dvector()));
                    writer.endObject();
                }
                writer.endArray();

                writer.endObject();
                writer.endArray();
            } catch (IOException ioe) {
                failed(ioe);
                return;
            }
            context.session().response(HttpStatus.SC_OK, sb.toString());
        }
    }

    private static class RawCallback
        extends AbstractProxySessionCallback<JsonObject>
    {
        private final Context context;

        public RawCallback(final Context context) {
            super(context.session());

            this.context = context;
        }

        @Override
        public void completed(final JsonObject facesObj) {
            StringBuilder sb = new StringBuilder();
            try (JsonWriter writer = JsonType.HUMAN_READABLE.create(new StringBuilderWriter(sb))) {
                JsonList faces = facesObj.asMap().getList("face_infos");
                faces.writeValue(writer);
            } catch (IOException | JsonException ioe) {
                failed(ioe);
                return;
            }
            context.session().response(HttpStatus.SC_OK, sb.toString());
        }
    }
}
