package ru.yandex.ps.disk.search;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

public class FaceCache {
    private final Cache<Long, UserFacesAndClusters> cache;
    public FaceCache(final Diface server) {
        cache = CacheBuilder.newBuilder()
            .maximumSize(server.config().cacheSize())
            .build();
    }

    public UserFacesAndClusters get(final Long prefix) {
        return cache.getIfPresent(prefix);
    }

    public void put(
        final Long prefix,
        final UserFacesAndClusters data)
    {
        cache.put(prefix, data);
    }
}
