package ru.yandex.ps.disk.search;

import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.ContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.StringCollectors;

public class FaceConsumer extends AbstractJsonAsyncTypesafeDomConsumer<List<Face>> {
    private final DiskDoc doc;
    private final FaceStat stat;

    public FaceConsumer(
        final HttpEntity entity,
        final LongFunction<StringCollectors> stringCollectorsFactory,
        final ContainerFactory containerFactory,
        final DiskDoc doc,
        final FaceStat stat)
        throws HttpException
    {
        super(entity, stringCollectorsFactory, containerFactory);

        this.doc = doc;
        this.stat = stat;
    }

    @Override
    protected List<Face> buildResult(
        final HttpContext context,
        final JsonObject value)
        throws Exception
    {
        JsonList facesJson = value.asMap().getListOrNull("face_infos");
        boolean cokeFormat = false;
        if (facesJson == null) {
            cokeFormat = true;
            facesJson = value.asMap().getList("faces");
        }
        List<Face> faces = new ArrayList<>(facesJson.size());
        int i = 0;
        for (JsonObject faceJson: facesJson) {
            Face face;
            if (cokeFormat) {
                face= Face.parseFromCoke(doc, i++, faceJson);
            } else {
                face = Face.parseFromModel(doc, stat, i++, faceJson);
            }

            if (face != null) {
                faces.add(face);
            }
        }

        return faces;
    }
}
