package ru.yandex.ps.disk.search;

import java.util.List;
import java.util.function.LongFunction;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.ContainerFactory;
import ru.yandex.json.parser.StringCollectors;
import ru.yandex.json.parser.StringCollectorsFactory;

public class FaceConsumerFactory
    implements HttpAsyncResponseConsumerFactory<List<Face>>
{
    private final LongFunction<StringCollectors> stringCollectorsFactory;
    private final ContainerFactory containerFactory;
    private final DiskDoc doc;
    private final FaceStat stat;

    public FaceConsumerFactory(final DiskDoc doc, final FaceStat stat) {
        this(
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE,
            doc,
            stat);
    }

    public FaceConsumerFactory(
        final LongFunction<StringCollectors> stringCollectorsFactory,
        final ContainerFactory containerFactory,
        final DiskDoc doc,
        final FaceStat stat)
    {
        this.stringCollectorsFactory = stringCollectorsFactory;
        this.containerFactory = containerFactory;
        this.doc = doc;
        this.stat = stat;
    }

    @Override
    public FaceConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new FaceConsumer(
            response.getEntity(),
            stringCollectorsFactory,
            containerFactory,
            doc,
            stat);
    }
}
