package ru.yandex.ps.disk.search;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.server.LoggingServerConnection;

public class FaceStat {
    private int clustersCreated;
    private int clustersDeleted;
    private int faces;
    private int sideFaces;
    private int bannedFaces;
    private int candidates;
    private int badCandidates;
    private int extractFailures;
    private int brokenDimensions;
    private int invertedDimensions;
    private int djfsFiltered;
    private int similarsDropped;
    private int similarsKept;
    private int exifWithoutMatch;

    public int sideFaces() {
        return sideFaces;
    }

    public synchronized FaceStat sideFaces(final int sideFaces) {
        this.sideFaces += sideFaces;
        return this;
    }

    public synchronized FaceStat bannedFace(final int bannedFace) {
        this.bannedFaces += bannedFace;
        return this;
    }

    public int faces() {
        return faces;
    }

    public synchronized FaceStat faces(final int faces) {
        this.faces += faces;
        return this;
    }

    public int candidates() {
        return candidates;
    }

    public synchronized FaceStat candidates(final int candidates) {
        this.candidates += candidates;
        return this;
    }

    public int badCandidates() {
        return badCandidates;
    }

    public synchronized FaceStat badCandidates(final int badCandidates) {
        this.badCandidates += badCandidates;
        return this;
    }

    public int extractFailures() {
        return extractFailures;
    }

    public synchronized FaceStat extractFailures(final int extractFailures) {
        this.extractFailures += extractFailures;
        return this;
    }

    public int djfsFiltered() {
        return djfsFiltered;
    }

    public synchronized FaceStat djfsFiltered(final int djfsFiltered) {
        this.djfsFiltered += djfsFiltered;
        return this;
    }

    public int clustersCreated() {
        return clustersCreated;
    }

    public synchronized FaceStat clustersCreated(final int clustersCreated) {
        this.clustersCreated += clustersCreated;
        return this;
    }

    public int clustersDeleted() {
        return clustersDeleted;
    }

    public synchronized FaceStat clustersDeleted(final int clustersDeleted) {
        this.clustersDeleted += clustersDeleted;
        return this;
    }

    public int similarsDropped() {
        return similarsDropped;
    }

    public FaceStat similarsDropped(final int similarsDropped) {
        this.similarsDropped = similarsDropped;
        return this;
    }

    public int similarsKept() {
        return similarsKept;
    }

    public FaceStat similarsKept(final int similarsKept) {
        this.similarsKept = similarsKept;
        return this;
    }

    public synchronized int brokenDimensions() {
        return brokenDimensions;
    }

    public synchronized FaceStat brokenDimensions(final int brokenDimensions) {
        this.brokenDimensions += brokenDimensions;
        return this;
    }

    public synchronized int invertedDimensions() {
        return invertedDimensions;
    }

    public synchronized FaceStat invertedDimensions(final int invertedDimensions) {
        this.invertedDimensions += invertedDimensions;
        return this;
    }

    public synchronized int exifWithoutMatch() {
        return invertedDimensions;
    }

    public synchronized FaceStat exifWithoutMatch(final int exifWithoutMatch) {
        this.exifWithoutMatch += exifWithoutMatch;
        return this;
    }

    @Override
    public String toString() {
        return "FaceStat{" +
            "clustersCreated=" + clustersCreated +
            ", clustersDeleted=" + clustersDeleted +
            ", faces=" + faces +
            ", sideFaces=" + sideFaces +
            ", bannedFaces=" + bannedFaces +
            ", candidates=" + candidates +
            ", badCandidates=" + badCandidates +
            ", extractFailures=" + extractFailures +
            ", brokenDimensions=" + brokenDimensions +
            ", invertedDimensions=" + invertedDimensions +
            ", djfsFiltered=" + djfsFiltered +
            ", exifWithoutMatch=" + exifWithoutMatch +
            '}';
    }

    public void addToSession(final ProxySession session) {
        LoggingServerConnection connection = session.connection();
        connection.setSessionInfo("faces", Long.toString(faces));
        connection.setSessionInfo("clusters", Long.toString(clustersCreated));
        connection.setSessionInfo("clusters", Long.toString(clustersCreated));
        connection.setSessionInfo("candidates", Long.toString(candidates));
        connection.setSessionInfo("sidefaces", Long.toString(sideFaces));
        connection.setSessionInfo("bannedFaces", Long.toString(bannedFaces));
        connection.setSessionInfo("brokenDimensions", Long.toString(brokenDimensions));
        connection.setSessionInfo("invertedDimensions", Long.toString(invertedDimensions));
        connection.setSessionInfo("extract_failure", Long.toString(extractFailures));
        connection.setSessionInfo("djfs_filter", Long.toString(djfsFiltered));
        connection.setSessionInfo("bad_candidate", Long.toString(badCandidates));
        connection.setSessionInfo("similars_dropped", Long.toString(similarsDropped));
        connection.setSessionInfo("similars_kept", Long.toString(similarsKept));
    }
}
