package ru.yandex.ps.disk.search;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.string.NonNegativeLongValidator;
import ru.yandex.search.disk.DiskFaceActionType;
import ru.yandex.search.disk.DiskFaceActionTypeParser;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.util.string.StringUtils;

public class PostIndexContext
    extends AbstractDifaceContext
{
    private final LongPrefix prefix;
    private final Long queueId;
    private final Long refQueueId;
    private final String refQueue;
    private final String idsRange;
    private final DiskFaceActionType action;
    private final long timestamp;
    private final List<DiskDoc> docs;

    public PostIndexContext(
        final Diface server,
        final ProxySession session,
        final List<JsonObject> list)
        throws JsonException, HttpException
    {
        super(server, session);

        docs = new ArrayList<>(list.size());

        Long prefix = session.params().getLong("prefix", null);
        if (prefix == null) {
            prefix = session.params().getLong("uid");
        }

        if (list.size() == 1) {
            docs.add(DiskDoc.parseSingleDoc(list.get(0).asMap(), session.params()));
        } else {
            for (JsonObject item: list) {
                JsonMap map = item.asMap();
                docs.add(new DiskDoc(map));
            }
        }

        if (docs.size() <= 0) {
            idsRange = "";
        } else if (docs.size() == 1) {
            idsRange = docs.get(0).resourceId();
        } else {
            idsRange =
                StringUtils.concat(
                    docs.get(0).resourceId(),
                    '-',
                    docs.get(docs.size() - 1).resourceId());
        }
        this.prefix = new LongPrefix(prefix);
        this.timestamp = System.currentTimeMillis();
        Long queueId = session.headers().getLong(
            YandexHeaders.ZOO_QUEUE_ID,
            Long.MIN_VALUE);
        // zooQueueId could absent for parallel requests, while this
        // value is taken from zoo-queue-id CGI-param
        if (queueId < 0) {
            queueId = session.params().get(
                "zoo-queue-id",
                NonNegativeLongValidator.INSTANCE);
        }

        this.refQueueId = session.params().getLong("ref_queue_id", -1L);
        this.refQueue = session.params().getString("ref_queue", "");
        this.action = session.params().get("action", DiskFaceActionTypeParser.INSTANCE);

        this.queueId = queueId;
    }

    public DiskFaceActionType action() {
        return action;
    }

    public long timestamp() {
        return timestamp;
    }

    @Override
    public ProxySession session() {
        return session;
    }

    public LongPrefix prefix() {
        return prefix;
    }

    public String idsRange() {
        return idsRange;
    }

    @Override
    public double minClusterSize() {
        return server.config().minClusterSize();
    }

    @Override
    public double clusterThreshold() {
        return server.config().clusterThreshold();
    }

    @Override
    public Diface server() {
        return server;
    }

    public Long queueId() {
        return queueId;
    }

    public Long refQueueId() {
        return refQueueId;
    }

    public String refQueue() {
        return refQueue;
    }

    public List<DiskDoc> docs() {
        return docs;
    }
}
