package ru.yandex.ps.disk.search;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UserFacesAndClusters {
    private final Map<String, List<Face>> faces;
    private final List<Cluster> clusters;

    public UserFacesAndClusters(
        final Map<String, List<Face>> faces,
        final List<Cluster> clusters)
    {
        this.faces = faces;
        this.clusters = clusters;
    }

    public UserFacesAndClusters(final List<Face> faces, final List<Cluster> clusters) {
        this.faces = new LinkedHashMap<>(faces.size() << 1);
        for (Face face: faces) {
            this.faces.computeIfAbsent(
                face.resourceId(),
                (k) -> new ArrayList<>(1))
                .add(face);
        }

        this.clusters = clusters;
    }

    public List<Face> facesByResourceId(final String resourceId) {
        return faces.get(resourceId);
    }

    public Map<String, List<Face>> faces() {
        return faces;
    }

    public List<Cluster> clusters() {
        return clusters;
    }

    @Override
    public String toString() {
        return "UserFacesAndClusters{" +
            "resources=" + faces.size() +
            ", clusters=" + clusters.size() +
            '}';
    }
}
