package ru.yandex.ps.disk.search.config;

import java.net.URI;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.PositiveIntegerValidator;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;

public abstract class AbstractDifaceConfigBuilder
    <T extends AbstractDifaceConfigBuilder<T>>
     extends AbstractUniversalSearchProxyConfigBuilder<T>
     implements DifaceConfig
{
    private HttpHostConfigBuilder imageparserConfig;
    private HttpHostConfigBuilder cokemulatorConfig;
    private URIConfigBuilder djfsConfig;
    private StaticFacesConfigBuilder sideConfig;
    private StaticFacesConfigBuilder bannedFacesConfig;
    private String faceIndexQueue;
    private String reindexQuery;
    private double clusterThreshold;
    private double minClusterSize;
    private double checkDimensionsThreshold;
    private int cacheSize;
    private int producerBatchSize;
    private int faceExtractBatchSize;
    private int djfsBatchSize;
    private int maxImagesForReindex;
    private URI faceDeltaCallback;
    private URI faceReindexCallback;
    private boolean defaultCokemulator;
    private boolean checkDimensions;
    private boolean tryOrigAfterPreviewFail;

    protected AbstractDifaceConfigBuilder(final DifaceConfig config) {
        super(config);
        cokemulatorConfig(config.cokemulatorConfig());
        imageparserConfig(config.imageparserConfig());
        faceIndexQueue(config.faceIndexQueue());
        clusterThreshold(config.clusterThreshold());
        minClusterSize(config.minClusterSize());
        checkDimensionsThreshold(config.checkDimensionsThreshold());
        cacheSize(config.cacheSize());
        defaultCokemulator(config.defaultCokemulator());
        checkDimensions(config.checkDimensions());
        sideConfig(config.sideConfig());
        bannedFacesConfig(config.bannedFacesConfig());
        faceDeltaCallback(config.faceDeltaCallback());
        faceReindexCallback(config.faceReindexCallback());
        producerBatchSize(config.producerBatchSize());
        faceExtractBatchSize(config.faceExtractBatchSize());
        djfsConfig(config.djfsConfig());
        reindexQuery(config.reindexQuery());
        djfsBatchSize(config.djfsBatchSize());
        tryOrigAfterPreviewFail(config.tryOrigAfterPreviewFail());
        maxImagesForReindex(config.maxImagesForReindex());
    }

    protected AbstractDifaceConfigBuilder(
        final IniConfig config,
        final DifaceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        this.imageparserConfig =
            new HttpHostConfigBuilder(
                config.section("imageparser"),
                defaults.imageparserConfig());
        this.cokemulatorConfig =
            new HttpHostConfigBuilder(
                config.section("cokemulator"),
                defaults.cokemulatorConfig());
        this.faceIndexQueue =
            config.getString("face-index-queue", defaults.faceIndexQueue());
        this.clusterThreshold =
            config.getDouble("cluster-threshold", defaults.clusterThreshold());
        this.checkDimensionsThreshold =
            config.getDouble("check-dimensions-threshold", defaults.checkDimensionsThreshold());
        this.reindexQuery =
            config.getString("reindex-query", defaults.reindexQuery());
        this.minClusterSize =
            config.getDouble("min-cluster-size", defaults.minClusterSize());
        this.cacheSize = config.getInt("cache-size", defaults.cacheSize());
        this.defaultCokemulator =
            config.getBoolean("default-cokemulator", defaults.defaultCokemulator());
        this.checkDimensions =
            config.getBoolean("check-dimensions", defaults.checkDimensions());

        this.tryOrigAfterPreviewFail =
            config.getBoolean("original-after-preview-fail", defaults.tryOrigAfterPreviewFail());
        this.maxImagesForReindex = config.getInt("max-images-for-reindex", defaults.maxImagesForReindex());
        this.producerBatchSize
            = config.get(
                "producer-batch-size",
            defaults.producerBatchSize(),
            PositiveIntegerValidator.INSTANCE);
        this.faceExtractBatchSize
            = config.get(
            "face-extract-batch-size",
            defaults.faceExtractBatchSize(),
            PositiveIntegerValidator.INSTANCE);
        this.djfsBatchSize
            = config.getInt(
                "djfs-batch-size",
            defaults.djfsBatchSize());
        this.faceDeltaCallback =
            config.getURI("face-delta-callback", defaults.faceDeltaCallback());
        this.faceReindexCallback =
            config.getURI("face-reindex-callback", defaults.faceReindexCallback());

        this.djfsConfig = new URIConfigBuilder(config.section("djfs"), defaults.djfsConfig());
        IniConfig sideSection = config.sectionOrNull("side");
        if (sideSection != null) {
            sideConfig = new StaticFacesConfigBuilder(sideSection, defaults.sideConfig());
        } else {
            sideConfig = new StaticFacesConfigBuilder(defaults.sideConfig());
        }

        IniConfig bannedFacesSection = config.sectionOrNull("banned");
        if (bannedFacesSection != null) {
            bannedFacesConfig = new StaticFacesConfigBuilder(
                bannedFacesSection,
                defaults.bannedFacesConfig());
        } else {
            bannedFacesConfig = new StaticFacesConfigBuilder(defaults.bannedFacesConfig());
        }
    }

    @Override
    public boolean checkDimensions() {
        return checkDimensions;
    }

    public T checkDimensions(final boolean checkDimensions) {
        this.checkDimensions = checkDimensions;
        return self();
    }

    @Override
    public double checkDimensionsThreshold() {
        return checkDimensionsThreshold;
    }

    public T checkDimensionsThreshold(final double value) {
        this.checkDimensionsThreshold = value;
        return self();
    }

    @Override
    public StaticFacesConfigBuilder bannedFacesConfig() {
        return bannedFacesConfig;
    }

    public T bannedFacesConfig(
        final StaticFacesConfig bannedFacesConfig) {
        this.bannedFacesConfig = new StaticFacesConfigBuilder(bannedFacesConfig);
        return self();
    }

    @Override
    public int maxImagesForReindex() {
        return maxImagesForReindex;
    }

    public T maxImagesForReindex(final int maxImagesForReindex) {
        this.maxImagesForReindex = maxImagesForReindex;
        return self();
    }

    @Override
    public boolean defaultCokemulator() {
        return defaultCokemulator;
    }

    public T defaultCokemulator(final boolean defaultCokemulator) {
        this.defaultCokemulator = defaultCokemulator;
        return self();
    }

    @Override()
    public HttpHostConfigBuilder imageparserConfig() {
        return imageparserConfig;
    }

    public T imageparserConfig(final HttpHostConfig value) {
        this.imageparserConfig = new HttpHostConfigBuilder(value);
        return self();
    }

    @Override()
    public HttpHostConfigBuilder cokemulatorConfig() {
        return cokemulatorConfig;
    }

    public T cokemulatorConfig(final HttpHostConfig value) {
        this.cokemulatorConfig = new HttpHostConfigBuilder(value);
        return self();
    }

    @Override()
    public String faceIndexQueue() {
        return faceIndexQueue;
    }

    public T faceIndexQueue(final String value) {
        this.faceIndexQueue = value;
        return self();
    }

    @Override()
    public double clusterThreshold() {
        return clusterThreshold;
    }

    public T clusterThreshold(final double value) {
        this.clusterThreshold = value;
        return self();
    }

    @Override()
    public double minClusterSize() {
        return minClusterSize;
    }

    public T minClusterSize(final double value) {
        this.minClusterSize = value;
        return self();
    }

    @Override()
    public int cacheSize() {
        return cacheSize;
    }

    public T cacheSize(final int value) {
        this.cacheSize = value;
        return self();
    }

    @Override
    public StaticFacesConfigBuilder sideConfig() {
        return sideConfig;
    }

    public T sideConfig(final StaticFacesConfig sideConfig) {
        this.sideConfig = new StaticFacesConfigBuilder(sideConfig);
        return self();
    }

    @Override
    public int producerBatchSize() {
        return producerBatchSize;
    }

    public T producerBatchSize(final int producerBatchSize) {
        this.producerBatchSize = producerBatchSize;
        return self();
    }

    @Override
    public int faceExtractBatchSize() {
        return faceExtractBatchSize;
    }

    public T faceExtractBatchSize(final int faceExtractBatchSize) {
        this.faceExtractBatchSize = faceExtractBatchSize;
        return self();
    }

    @Override
    public URI faceDeltaCallback() {
        return faceDeltaCallback;
    }

    public T faceDeltaCallback(final URI faceDeltaCallback) {
        this.faceDeltaCallback = faceDeltaCallback;
        return self();
    }

    @Override
    public URIConfigBuilder djfsConfig() {
        return djfsConfig;
    }

    public T djfsConfig(final URIConfig djfsConfig) {
        this.djfsConfig = new URIConfigBuilder(djfsConfig);
        return self();
    }

    @Override
    public URI faceReindexCallback() {
        return faceReindexCallback;
    }

    public T faceReindexCallback(final URI faceReindexCallback) {
        this.faceReindexCallback = faceReindexCallback;
        return self();
    }

    @Override
    public String reindexQuery() {
        return reindexQuery;
    }

    public T reindexQuery(final String reindexQuery) {
        this.reindexQuery = reindexQuery;
        return self();
    }

    @Override
    public int djfsBatchSize() {
        return djfsBatchSize;
    }

    public T djfsBatchSize(final int djfsBatchSize) {
        this.djfsBatchSize = djfsBatchSize;
        return self();
    }

    @Override
    public boolean tryOrigAfterPreviewFail() {
        return tryOrigAfterPreviewFail;
    }

    public T tryOrigAfterPreviewFail(
        final boolean tryOrigAfterPreviewFail)
    {
        this.tryOrigAfterPreviewFail = tryOrigAfterPreviewFail;
        return self();
    }

    @Override
    public abstract T self();
}
