package ru.yandex.ps.disk.search.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractStaticFacesConfigBuilder
    <T extends AbstractStaticFacesConfigBuilder<T>>
     implements StaticFacesConfig
{
    private boolean enabled;
    private String path;

    protected AbstractStaticFacesConfigBuilder(final StaticFacesConfig config) {
        enabled(config.enabled());

    }

    protected AbstractStaticFacesConfigBuilder(
        final IniConfig config,
        final StaticFacesConfig defaults)
        throws ConfigException
    {
        this.enabled = config.getBoolean("enabled", defaults.enabled());
        this.path = config.getString("path", defaults.path());
    }

    @Override()
    public boolean enabled() {
        return enabled;
    }

    public T enabled(final boolean value) {
        this.enabled = value;
        return self();
    }

    @Override
    public String path() {
        return path;
    }

    public T path(final String path) {
        this.path = path;
        return self();
    }

    protected abstract T self();
}
