package ru.yandex.ps.disk.search.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class DifaceConfigBuilder
     extends AbstractDifaceConfigBuilder<DifaceConfigBuilder>
{
    public DifaceConfigBuilder() {
        this(DifaceConfigDefaults.INSTANCE);
    }

    public DifaceConfigBuilder(final DifaceConfig config) {
        super(config);
    }

    public DifaceConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, DifaceConfigDefaults.INSTANCE);
    }

    public DifaceConfigBuilder(
        final IniConfig config,
        final DifaceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableDifaceConfig build() throws ConfigException {
        return new ImmutableDifaceConfig(
            this);
    }

    @Override
    public DifaceConfigBuilder self() {
        return this;
    }
}
