package ru.yandex.ps.disk.search.config;

import java.net.URI;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigDefaults;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfigDefaults;

public class DifaceConfigDefaults
     extends UniversalSearchProxyConfigDefaults
     implements DifaceConfig
{
    public static final double THRESHOLD = 0.65;
    public static final int CACHE_SIZE = 100000;
    public static final double MIN_CLUSTER_SIZE = 8;

    public static final DifaceConfigDefaults INSTANCE =
        new DifaceConfigDefaults();

    @Override
    public HttpHostConfig imageparserConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig cokemulatorConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    protected DifaceConfigDefaults() {
    }

    @Override
    public String faceIndexQueue() {
        return null;
    }

    @Override
    public double clusterThreshold() {
        return THRESHOLD;
    }

    @Override
    public double minClusterSize() {
        return MIN_CLUSTER_SIZE;
    }

    @Override
    public int cacheSize() {
        return CACHE_SIZE;
    }

    @Override
    public boolean defaultCokemulator() {
        return false;
    }

    @Override
    public StaticFacesConfig sideConfig() {
        return StaticFacesConfigDefaults.INSTANCE;
    }

    @Override
    public StaticFacesConfig bannedFacesConfig() {
        return StaticFacesConfigDefaults.INSTANCE;
    }

    @Override
    public int producerBatchSize() {
        return 500;
    }

    @Override
    public int faceExtractBatchSize() {
        return 60;
    }

    @Override
    public int djfsBatchSize() {
        return 60;
    }

    @Override
    public URI faceDeltaCallback() {
        return null;
    }

    @Override
    public URIConfig djfsConfig() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public URI faceReindexCallback() {
        return null;
    }

    @Override
    public String reindexQuery() {
        return null;
    }

    @Override
    public boolean tryOrigAfterPreviewFail() {
        return false;
    }

    @Override
    public int maxImagesForReindex() {
        return -1;
    }

    @Override
    public boolean checkDimensions() {
        return false;
    }

    @Override
    public double checkDimensionsThreshold() {
        return 0.1;
    }
}
