package ru.yandex.ps.disk.search.config;

import java.net.URI;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableURIConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutableDifaceConfig
     extends ImmutableUniversalSearchProxyConfig
     implements DifaceConfig
{
    private final ImmutableHttpHostConfig imageparserConfig;
    private final ImmutableHttpHostConfig cokemulatorConfig;
    private final ImmutableStaticFacesConfig sideConfig;
    private final ImmutableStaticFacesConfig bannedFacesConfig;
    private final ImmutableURIConfig djfsConfig;
    private final String faceIndexQueue;
    private final String reindexQuery;
    private final double clusterThreshold;
    private final double minClusterSize;
    private final double checkDimensionsThreshold;
    private final int cacheSize;
    private final int maxImagesForReindex;
    private final boolean defaultCokemulator;
    private final boolean checkDimensions;
    private final boolean tryOrigAfterPreviewFail;
    private final int producerBatchSize;
    private final int faceExtractBatchSize;
    private final int djfsBatchSize;
    private final URI faceDeltaCallback;
    private final URI faceReindexCallback;

    public ImmutableDifaceConfig(
        final DifaceConfig config)
        throws ConfigException
    {
        super(config);
        this.cokemulatorConfig = new ImmutableHttpHostConfig(
            config.cokemulatorConfig());
        this.imageparserConfig = new ImmutableHttpHostConfig(
            config.imageparserConfig());
        this.faceIndexQueue = config.faceIndexQueue();
        this.clusterThreshold = config.clusterThreshold();
        this.minClusterSize = config.minClusterSize();
        this.cacheSize = config.cacheSize();
        this.defaultCokemulator = config.defaultCokemulator();
        this.tryOrigAfterPreviewFail = config.tryOrigAfterPreviewFail();
        this.sideConfig = new ImmutableStaticFacesConfig(config.sideConfig());
        this.bannedFacesConfig = new ImmutableStaticFacesConfig(config.bannedFacesConfig());
        this.producerBatchSize = config.producerBatchSize();
        this.faceExtractBatchSize = config.faceExtractBatchSize();
        this.djfsBatchSize = config.djfsBatchSize();
        this.faceDeltaCallback = config.faceDeltaCallback();
        this.faceReindexCallback = config.faceReindexCallback();
        this.djfsConfig = new ImmutableURIConfig(config.djfsConfig());
        this.reindexQuery = config.reindexQuery();
        this.maxImagesForReindex = config.maxImagesForReindex();
        this.checkDimensions = config.checkDimensions();
        this.checkDimensionsThreshold = config.checkDimensionsThreshold();
    }

    @Override
    public ImmutableHttpHostConfig imageparserConfig() {
        return imageparserConfig;
    }

    @Override
    public ImmutableHttpHostConfig cokemulatorConfig() {
        return cokemulatorConfig;
    }

    @Override
    public String faceIndexQueue() {
        return faceIndexQueue;
    }

    @Override
    public double clusterThreshold() {
        return clusterThreshold;
    }

    @Override
    public double minClusterSize() {
        return minClusterSize;
    }

    @Override
    public int cacheSize() {
        return cacheSize;
    }

    @Override
    public boolean defaultCokemulator() {
        return defaultCokemulator;
    }

    @Override
    public ImmutableStaticFacesConfig sideConfig() {
        return sideConfig;
    }

    @Override
    public ImmutableStaticFacesConfig bannedFacesConfig() {
        return bannedFacesConfig;
    }

    @Override
    public int producerBatchSize() {
        return producerBatchSize;
    }

    @Override
    public int faceExtractBatchSize() {
        return faceExtractBatchSize;
    }

    @Override
    public URI faceDeltaCallback() {
        return faceDeltaCallback;
    }

    @Override
    public ImmutableURIConfig djfsConfig() {
        return djfsConfig;
    }

    @Override
    public URI faceReindexCallback() {
        return faceReindexCallback;
    }

    @Override
    public String reindexQuery() {
        return reindexQuery;
    }

    @Override
    public int djfsBatchSize() {
        return djfsBatchSize;
    }

    @Override
    public boolean tryOrigAfterPreviewFail() {
        return tryOrigAfterPreviewFail;
    }

    @Override
    public int maxImagesForReindex() {
        return maxImagesForReindex;
    }

    @Override
    public double checkDimensionsThreshold() {
        return checkDimensionsThreshold;
    }

    @Override
    public boolean checkDimensions() {
        return checkDimensions;
    }
}
