package ru.yandex.ps.disk.search.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class StaticFacesConfigBuilder
     extends AbstractStaticFacesConfigBuilder<StaticFacesConfigBuilder>
{
    public StaticFacesConfigBuilder() {
        this(StaticFacesConfigDefaults.INSTANCE);
    }

    public StaticFacesConfigBuilder(final StaticFacesConfig config) {
        super(config);
    }

    public StaticFacesConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, StaticFacesConfigDefaults.INSTANCE);
    }

    public StaticFacesConfigBuilder(
        final IniConfig config,
        final StaticFacesConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableStaticFacesConfig build() throws ConfigException {
        return new ImmutableStaticFacesConfig(
            this);
    }

    @Override
    protected StaticFacesConfigBuilder self() {
        return this;
    }
}
