package ru.yandex.ps.disk.search.delta;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import ru.yandex.disk.search.face.DeltaItem;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.ps.disk.search.Cluster;
import ru.yandex.ps.disk.search.FaceBackendFields;
import ru.yandex.ps.disk.search.PostIndexContext;
import ru.yandex.util.string.StringUtils;

public class ClusterDelta implements JsonValue {
    private final String id;
    private final String clusterId;
    private final long version;
    private final String refQueue;
    private final long refQueueId;
    private final long timestamp;
    private final List<DeltaItem> items;

    public ClusterDelta(
        final long prefix,
        final String clusterId,
        final long version,
        final String refQueue,
        final long refQueueId,
        final long timestamp,
        final List<DeltaItem> items)
    {
        this.clusterId = clusterId;
        this.version = version;
        this.refQueue = refQueue;
        this.refQueueId = refQueueId;
        this.timestamp = timestamp;
        this.items = items;

        StringBuilder idBuilder = new StringBuilder(60);
        idBuilder.append("facedelta_");
        idBuilder.append(prefix);
        idBuilder.append('_');
        idBuilder.append(clusterId);
        idBuilder.append('_');
        idBuilder.append(version);

        id = idBuilder.toString();
    }

    public void add(final DeltaItem item) {
        items.add(item);
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("id");
        writer.value(id);
        writer.key("type");
        writer.value("face_delta");
        writer.key(FaceBackendFields.FACEDELTA_CLUSTER_ID.stored());
        writer.value(clusterId);
        writer.key(FaceBackendFields.FACEDELTA_REF.stored());
        writer.value(StringUtils.concat(refQueue,  ':', String.valueOf(refQueueId)));
        writer.key(FaceBackendFields.FACEDELTA_VERSION.stored());
        writer.value(version);
        writer.key(FaceBackendFields.FACEDELTA_TIMESTAMP.stored());
        writer.value(timestamp);
        writer.key(FaceBackendFields.FACEDELTA_DATA.stored());
        writer.value(JsonType.NORMAL.toString(items));
        writer.endObject();
    }

    public static ClusterDelta create(
        final Cluster cluster,
        final PostIndexContext context,
        final long version)
    {
        return new ClusterDelta(
            context.prefix().prefix(),
            cluster.id(),
            version,
            context.refQueue(),
            context.refQueueId(),
            context.timestamp(),
            new ArrayList<>());
    }
}
