package ru.yandex.ps.disk.search.reindex;

import java.io.IOException;

import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.ps.disk.search.FaceStat;
import ru.yandex.ps.disk.search.UserFacesAndClusters;

public class ReindexCallback
    extends AbstractProxySessionCallback<UserFacesAndClusters>
{
    private final FaceStat stat;
    private final ReindexContext context;

    public ReindexCallback(final ReindexContext context, final FaceStat stat) {
        super(context.session());

        this.stat = stat;
        this.context = context;
    }

    @Override
    public void completed(final UserFacesAndClusters data) {
        context.server().updateCache(context.prefix().prefix(), data);
        //context.stat().addToSession(session);
        if (context.action() == ReindexAction.PRINT || context.action() == ReindexAction.STORE_AND_PRINT) {
            StringBuilderWriter sbw = new StringBuilderWriter();
            try (JsonWriter jw = JsonType.HUMAN_READABLE.create(sbw)) {
                jw.startObject();
                jw.key("clusters");
                jw.value(data.clusters());
                jw.key("faces");
                jw.value(data.faces());
                jw.endObject();
            } catch (IOException ioe) {
                failed(ioe);
                return;
            }

            session.response(HttpStatus.SC_OK, sbw.toString());
        } else {
            session.response(HttpStatus.SC_OK);
        }

        session.response(HttpStatus.SC_OK, stat.toString());
        context.logger().info(stat.toString());

    }
}
