package ru.yandex.ps.disk.search.reindex;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.string.NonNegativeIntegerValidator;
import ru.yandex.ps.disk.search.AbstractDifaceContext;
import ru.yandex.ps.disk.search.Diface;
import ru.yandex.ps.disk.search.UserFacesAndClusters;
import ru.yandex.ps.disk.search.config.ImmutableDifaceConfig;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;

final class ReindexContext
    extends AbstractDifaceContext
    implements UniversalSearchProxyRequestContext
{
    private final AsyncClient searchClient;
    private final User user;
    private final LongPrefix prefix;
    private final FutureCallback<UserFacesAndClusters> callback;
    private final ReindexAction action;
    private final int batch;
    private final int djfsBatch;
    private final int length;
    private final long rateLimitRetryDelay;
    private final boolean reextract;
    private final PrefixedLogger logger;
    private final AtomicInteger failed = new AtomicInteger(0);
    private final boolean picasa;

    public ReindexContext(
        final Diface server,
        final ProxySession session)
        throws BadRequestException
    {
        super(server, session);

        String service = session.params().getString("fetch-service", "disk_queue");

        action =
            session.params().getEnum(ReindexAction.class, "action", ReindexAction.STORE);
        this.length = session.params().getInt("length", server.config().maxImagesForReindex());
        this.rateLimitRetryDelay = session.params().getLong("rl-retry-ms", TimeUnit.SECONDS.toMillis(60));
        this.reextract = session.params().getBoolean("reextract", true);
        this.picasa = session.params().getBoolean("picasa", false);
        this.batch =
            session.params().get(
                "batch",
                server.config().faceExtractBatchSize(),
                NonNegativeIntegerValidator.INSTANCE);
        this.djfsBatch =
            session.params().get(
                "djfs-batch",
                server.config().djfsBatchSize(),
                NonNegativeIntegerValidator.INSTANCE);

        prefix = new LongPrefix(session.params().getLong("prefix"));
        this.logger = session.logger().addPrefix(prefix.toStringFast());
        this.user = new User(service, prefix);
        this.searchClient = server.searchClient().adjust(session.context());
        this.callback = new ReindexCallback(this, stat);
    }

    public long rateLimitRetryDelay() {
        return rateLimitRetryDelay;
    }

    @Override
    public PrefixedLogger logger() {
        return logger;
    }

    public void extractFailed() {
        failed.incrementAndGet();
    }

    public int failedCount() {
        return failed.get();
    }

    public boolean reextract() {
        return reextract;
    }

    public int djfsBatch() {
        return djfsBatch;
    }

    @Override
    public double minClusterSize() {
        return minClusterSize;
    }

    @Override
    public double clusterThreshold() {
        return clusterThreshold;
    }

    @Override
    public ProxySession session() {
        return session;
    }

    public ReindexAction action() {
        return action;
    }

    public boolean picasa() {
        return picasa;
    }

    public int batch() {
        return batch;
    }

    public int length() {
        return length;
    }

    public AsyncClient searchClient() {
        return searchClient;
    }

    public LongPrefix prefix() {
        return prefix;
    }

    @Override
    public long version() {
        return version;
    }

    public FutureCallback<UserFacesAndClusters> callback() {
        return callback;
    }

    @Override
    public User user() {
        return user;
    }

    @Override
    public Long minPos() {
        return null;
    }

    @Override
    public AbstractAsyncClient<?> client() {
        return searchClient;
    }

    @Override
    public long lagTolerance() {
        return 0L;
    }

    public ImmutableDifaceConfig config() {
        return server.config();
    }

    @Override
    public boolean listener() {
        return false;
    }
}
