package ru.yandex.ps.disk.search.reindex;

public class ReindexStat {
    private int clusters;
    private int faces;
    private int sideFaces;
    private int candidates;
    private int badCandidates;
    private int extractFailures;
    private int djfsFiltered;

    public int sideFaces() {
        return sideFaces;
    }

    public synchronized ReindexStat sideFaces(final int sideFaces) {
        this.sideFaces = sideFaces;
        return this;
    }

    public int clusters() {
        return clusters;
    }

    public synchronized ReindexStat clusters(final int clusters) {
        this.clusters = clusters;
        return this;
    }

    public int faces() {
        return faces;
    }

    public synchronized ReindexStat faces(final int faces) {
        this.faces = faces;
        return this;
    }

    public int candidates() {
        return candidates;
    }

    public synchronized ReindexStat candidates(final int candidates) {
        this.candidates = candidates;
        return this;
    }

    public int badCandidates() {
        return badCandidates;
    }

    public synchronized ReindexStat badCandidates(final int badCandidates) {
        this.badCandidates = badCandidates;
        return this;
    }

    public int extractFailures() {
        return extractFailures;
    }

    public synchronized ReindexStat extractFailures(final int extractFailures) {
        this.extractFailures = extractFailures;
        return this;
    }

    public int djfsFiltered() {
        return djfsFiltered;
    }

    public synchronized ReindexStat djfsFiltered(final int djfsFiltered) {
        this.djfsFiltered = djfsFiltered;
        return this;
    }

    @Override
    public String toString() {
        return "ReindexStat{" +
            "clusters=" + clusters +
            ", faces=" + faces +
            ", sideFaces=" + sideFaces +
            ", candidates=" + candidates +
            ", badCandidates=" + badCandidates +
            ", extractFailures=" + extractFailures +
            ", djfsFiltered=" + djfsFiltered +
            '}';
    }
}
