#!/bin/bash

source disk_indexer_config.sh
source classpath.sh

export CONSUMER_GROUP=$INDEXER_CONSUMER_GROUP
export disk_reindex_queue_TARGET_PORT=$BSCONFIG_IPORT

./disk_indexer_searchmap_generator.sh > searchmap.txt

CORE_DIR="/coredumps"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8

XMX=$(portoctl get self memory_limit_total)
XMX=$(echo $XMX | gawk '{print int($1 * 0.8 / 1048576)}')
XMS=$((XMX / 4))

MEM_ARGS="-Xms${XMS}M -Xmx${XMX}M"
DUMP_ARGS="
-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact
"
GC_ARGS="
-Xgcpolicy:gencon
-verbose:gc
-Xverbosegclog:/logs/gc#.log,10,10000
-Xgcthreads4
-Xconcurrentbackground4
"
NET_ARGS="
-Djava.net.preferIPv4Stack=false
-Djava.net.preferIPv6Addresses=true
"
CONSUMER_ARGS="
ru.yandex.dispatcher.consumer.ConsumerServer -config disk_indexer_consumer.conf
"
DISK_INDEXER_ARGS="
ru.yandex.search.disk.indexer.DiskIndexer disk_indexer.conf
"

exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=disk_indexer \
    -cp $CLASSPATH \
    ru.yandex.multistarter.MultiStarter \
    $CONSUMER_ARGS ";" $DISK_INDEXER_ARGS