#-*- coding: utf-8 -*-
import json
from optparse import OptionParser

import requests
import sys
import os
TEST_HOST = "http://mpfs01d.dst.yandex.net"
PROD_HOST = "https://mpfs.disk.yandex.net"

def build_it_key(key):
    return "{\"iteration_key\":\"" + key + "\"}"

def print_with_fields(data, fields):
    if not fields:
        print(json.dumps(data, ensure_ascii=False))
    else:
        if len(fields) == 1:
            print(data.get(fields[0]))
        else:
            result = {}
            for field in fields:
                result[field] = data.get(field)

            print(json.dumps(result, ensure_ascii=False))


if __name__ == '__main__':
    parser = OptionParser()
    parser.add_option("-u", "--uid", dest="uid", help="uid", default=None)
    parser.add_option("-m", "--mpfshost", dest="mpfs_host", help="mpfs host", default=None)
    parser.add_option("-f", "--fields", dest="fields", help="Fields for fetch", default='*')
    parser.add_option("-r", "--type", dest="res_type", help="Type for fetch dir/file", default=None)

    (options, args) = parser.parse_args()

    mpfsHost = options.mpfs_host

    if not options.uid:
        print('No uid')
        sys.exit(1)

    fields = []
    if options.fields != '*':
        fields = options.fields.strip().split(',')

    res_type = options.res_type

    uri = "{host}/json/indexer_snapshot?service=disk-indexer&uid={uid}".format(host=mpfsHost, uid=options.uid)
    it_key = None
    headers = {'X-Ya-Service-Ticket': os.environ.get('MPFS_TICKET')}
    while True:
        if not it_key:
            result = requests.post(uri, headers=headers)
        else:
            result = requests.post(uri, data=build_it_key(it_key), headers=headers)
        if result.status_code != 200:
            print('Failed', result, result.content,uri, build_it_key(it_key))
            sys.exit(1)

        data = result.json()

        for item in data['items']:
            if res_type:
                if item.get('type') == res_type:
                    print_with_fields(item, fields)
            else:
                print_with_fields(item, fields)

        it_key = data.get('iteration_key')
        if not it_key:
            break