#!/bin/bash
source disk-config-base.sh

set -e
set +x
# do not print secret
TVMID_ENV=${TVMID_ENV:-"TVM_CLIENT_ID"}
TVMSECRET_ENV=${TVMSECRET_ENV:-"SECRET"}
JAVA_PID=$(ps aux | grep java | grep -v grep | awk '{print $2}')
TVM_CLIENT_ID=$(cat /proc/$JAVA_PID/environ | tr '\0' '\n' | egrep -o "^$TVMID_ENV\=([0-9]+)" | cut -d'=' -f2)
SECRET=$(cat /proc/$JAVA_PID/environ | tr '\0' '\n' | egrep -o "^$TVMSECRET_ENV=[0-9a-z_A-Z\\\-]+" | cut -d'=' -f2)

which python3 || (apt-get update && apt-get install python3)
which tvmknife || (apt-get update && apt-get install -y yandex-passport-tvmknife)

export MPFS_TICKET=$(tvmknife get_service_ticket client_credentials -s ${TVM_CLIENT_ID} -d ${MPFS_TVM_CLIENT_ID} -S ${SECRET})
python3 mpfs_get.py --uid $1 --mpfshost "https://${MPFS_HOST}"
