package ru.yandex.search.disk.indexer;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractDiskIndexerConfigBuilder
    <T extends AbstractDiskIndexerConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements DiskIndexerConfig
{
    private URIConfigBuilder mpfsConfig;
    private HttpHostConfigBuilder producerConfig;
    private HttpHostConfigBuilder searchProxy;

    protected AbstractDiskIndexerConfigBuilder(final DiskIndexerConfig config) {
        super(config);
        mpfsConfig(config.mpfsConfig());
        producerConfig(config.producerConfig());
        searchProxy(config.searchProxy());
    }

    protected AbstractDiskIndexerConfigBuilder(
        final IniConfig config,
        final DiskIndexerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        mpfsConfig = new URIConfigBuilder(
            config.section("mpfs"),
            defaults.mpfsConfig());
        producerConfig = new HttpHostConfigBuilder(
            config.section("producer"),
            defaults.producerConfig());

        IniConfig proxySection = config.sectionOrNull("search_proxy");
        if (proxySection != null) {
            searchProxy = new HttpHostConfigBuilder(proxySection, defaults.searchProxy());
        } else {
            searchProxy = null;
        }

    }

    @Override
    public URIConfigBuilder mpfsConfig() {
        return mpfsConfig;
    }

    public T mpfsConfig(final URIConfig mpfsConfig) {
        this.mpfsConfig = new URIConfigBuilder(mpfsConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder producerConfig() {
        return producerConfig;
    }

    public T producerConfig(final HttpHostConfig producerConfig) {
        this.producerConfig = new HttpHostConfigBuilder(producerConfig);
        return self();
    }

    @Override
    public HttpHostConfigBuilder searchProxy() {
        return searchProxy;
    }

    public T searchProxy(final HttpHostConfig config) {
        if (config != null) {
            this.searchProxy = new HttpHostConfigBuilder(config);
        } else {
            this.searchProxy = null;
        }

        return self();
    }
}

