package ru.yandex.search.disk.indexer;

import java.io.IOException;
import java.io.Serializable;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.QueryConstructor;

public interface DiskIndexerBatchEntry extends Serializable {
    boolean add(DiskDocumentMeta doc);

    boolean isFull();

    boolean isEmpty();

    QueryConstructor uri(DiskReindexContext context)
        throws BadRequestException;

    // May be empty string for dataless requests, never null
    String body() throws IOException;
}

