package ru.yandex.search.disk.indexer;

import ru.yandex.parser.uri.QueryPostProcessor;

public class DiskIndexerBatchFactory {
    private final QueryPostProcessor queryPostProcessor;
    private final int batchSize;
    private final DiskIndexerBatchEntryFactory batchEntryFactory;

    public DiskIndexerBatchFactory(
        final QueryPostProcessor queryPostProcessor,
        final DiskReindexContext context)
    {
        this.queryPostProcessor = queryPostProcessor;
        batchSize = context.batchSize();
        int docsPerRequest = context.docsPerRequest();
        if (docsPerRequest == 1) {
            batchEntryFactory = DiskIndexerSingleDocBatchEntryFactory.INSTANCE;
        } else {
            DiskIndexerBatchEntryFactory batchEntryFactory =
                new DiskIndexerMultiDocBatchEntryFactory(docsPerRequest);
            if (context.cleanup()) {
                batchEntryFactory =
                    new DiskIndexerDuplicateLastDocBatchEntryFactory(
                        batchEntryFactory);
            }
            this.batchEntryFactory = batchEntryFactory;
        }
    }

    public DiskIndexerBatch createBatch() {
        if (batchSize == 1) {
            return new DiskIndexerSingleRequestBatch(
                batchEntryFactory,
                queryPostProcessor);
        } else {
            return new DiskIndexerMultiRequestBatch(
                batchEntryFactory,
                queryPostProcessor,
                batchSize);
        }
    }
}

