package ru.yandex.search.disk.indexer;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class DiskIndexerConfigBuilder
    extends AbstractDiskIndexerConfigBuilder<DiskIndexerConfigBuilder>
{
    public DiskIndexerConfigBuilder() {
        super(DiskIndexerConfigDefaults.INSTANCE);
    }

    public DiskIndexerConfigBuilder(final DiskIndexerConfig config) {
        super(config);
    }

    public DiskIndexerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, DiskIndexerConfigDefaults.INSTANCE);
    }

    public DiskIndexerConfigBuilder(
        final IniConfig config,
        final DiskIndexerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public DiskIndexerConfigBuilder self() {
        return this;
    }
}

