package ru.yandex.search.disk.indexer;

public class DiskIndexerDuplicateLastDocBatchEntryFactory
    implements DiskIndexerBatchEntryFactory
{
    private static final long serialVersionUID = 0L;

    private final DiskIndexerBatchEntryFactory batchEntryFactory;
    private DiskDocumentMeta lastDoc = null;

    public DiskIndexerDuplicateLastDocBatchEntryFactory(
        final DiskIndexerBatchEntryFactory batchEntryFactory)
    {
        this.batchEntryFactory = batchEntryFactory;
    }

    public void lastDoc(final DiskDocumentMeta lastDoc) {
        this.lastDoc = lastDoc;
    }

    @Override
    public DiskIndexerBatchEntry createBatchEntry() {
        DiskIndexerBatchEntry batchEntry =
            batchEntryFactory.createBatchEntry();
        if (lastDoc != null) {
            batchEntry =
                new DiskIndexerAddLastDocBatchEntry(batchEntry, lastDoc);
        }
        batchEntry = new DiskIndexerStoreLastDocBatchEntry(batchEntry, this);
        return batchEntry;
    }
}

