package ru.yandex.search.disk.indexer;

import java.io.IOException;
import java.util.ArrayList;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.util.string.StringUtils;

public class DiskIndexerMultiDocBatchEntry
    extends ArrayList<DiskDocumentMeta>
    implements DiskIndexerBatchEntry
{
    private static final long serialVersionUID = 0L;

    private final int docsPerRequest;

    public DiskIndexerMultiDocBatchEntry(final int docsPerRequest) {
        super(docsPerRequest);
        this.docsPerRequest = docsPerRequest;
    }

    @Override
    public boolean isFull() {
        return size() >= docsPerRequest;
    }

    @Override
    public QueryConstructor uri(final DiskReindexContext context)
        throws BadRequestException
    {
        QueryConstructor query = new QueryConstructor(context.uri());
        query.append("docs-count", size());
        query.append(
            "resource-ids",
            StringUtils.concat(
                get(0).resourceId(),
                '-',
                get(size() - 1).resourceId()));
        return query;
    }

    @Override
    public String body() throws IOException {
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = new JsonWriter(sbw)) {
            writer.startObject();
            writer.key("docs");
            writer.startArray();
            for (DiskDocumentMeta doc: this) {
                writer.startObject();
                writer.key("id");
                writer.value(doc.fileId());
                writer.key("resource_id");
                writer.value(doc.resourceId());
                writer.key("version");
                writer.value(doc.version());
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
        }
        return sbw.toString();
    }
}

