package ru.yandex.search.disk.indexer;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.QueryConstructor;

public class DiskIndexerSingleDocBatchEntry implements DiskIndexerBatchEntry {
    private static final long serialVersionUID = 0L;

    private DiskDocumentMeta doc = null;

    @Override
    public boolean add(final DiskDocumentMeta doc) {
        this.doc = doc;
        return true;
    }

    @Override
    public boolean isFull() {
        return doc != null;
    }

    @Override
    public boolean isEmpty() {
        return doc == null;
    }

    @Override
    public QueryConstructor uri(final DiskReindexContext context)
        throws BadRequestException
    {
        return uri(context, doc);
    }

    public static QueryConstructor uri(
        final DiskReindexContext context,
        final DiskDocumentMeta doc)
        throws BadRequestException
    {
        QueryConstructor query = new QueryConstructor(context.uri());
        query.append("resource_id", doc.resourceId());
        query.append("id", doc.fileId());
        return query;
    }

    @Override
    public String body() {
        return "";
    }
}

