package ru.yandex.search.disk.indexer;

import java.io.IOException;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.parser.uri.QueryPostProcessor;

public class DiskIndexerSingleRequestBatch implements DiskIndexerBatch {
    private final DiskIndexerBatchEntry batchEntry;
    private final QueryPostProcessor queryPostProcessor;

    public DiskIndexerSingleRequestBatch(
        final DiskIndexerBatchEntryFactory batchEntryFactory,
        final QueryPostProcessor queryPostProcessor)
    {
        batchEntry = batchEntryFactory.createBatchEntry();
        this.queryPostProcessor = queryPostProcessor;
    }

    @Override
    public boolean add(final DiskDocumentMeta doc) {
        return batchEntry.add(doc);
    }

    @Override
    public boolean isFull() {
        return batchEntry.isFull();
    }

    @Override
    public boolean isEmpty() {
        return batchEntry.isEmpty();
    }

    @Override
    public BasicAsyncRequestProducerGenerator createRequest(
        final DiskReindexContext context)
        throws BadRequestException, IOException
    {
        return createRequest(context, batchEntry, queryPostProcessor);
    }

    public static BasicAsyncRequestProducerGenerator createRequest(
        final DiskReindexContext context,
        final DiskIndexerBatchEntry batchEntry,
        final QueryPostProcessor queryPostProcessor)
        throws BadRequestException, IOException
    {
        BasicAsyncRequestProducerGenerator producerGenerator =
            new BasicAsyncRequestProducerGenerator(
                queryPostProcessor.apply(batchEntry.uri(context)).toString(),
                batchEntry.body());
        producerGenerator.addHeader(
            YandexHeaders.ZOO_SHARD_ID,
            context.shard());
        return producerGenerator;
    }
}

