package ru.yandex.search.disk.indexer;

public class DiskIndexerStoreLastDocBatchEntry
    extends FilterDiskIndexerBatchEntry
{
    private static final long serialVersionUID = 0L;

    private final DiskIndexerDuplicateLastDocBatchEntryFactory lastDocStorage;

    public DiskIndexerStoreLastDocBatchEntry(
        final DiskIndexerBatchEntry batchEntry,
        final DiskIndexerDuplicateLastDocBatchEntryFactory lastDocStorage)
    {
        super(batchEntry);
        this.lastDocStorage = lastDocStorage;
    }

    @Override
    public boolean add(final DiskDocumentMeta doc) {
        boolean result = super.add(doc);
        lastDocStorage.lastDoc(doc);
        return result;
    }
}

