package ru.yandex.search.disk.indexer;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public enum DiskSnapshotConsumerFactory
    implements HttpAsyncResponseConsumerFactory<DiskSnapshot>
{
    INSTANCE {
        @Override
        public DiskSnapshotConsumer create(
            final HttpAsyncRequestProducer producer,
            final HttpResponse response)
            throws HttpException
        {
            return new DiskSnapshotConsumer(response.getEntity(), false);
        }
    },
    WITH_PATH {
        @Override
        public DiskSnapshotConsumer create(
            final HttpAsyncRequestProducer producer,
            final HttpResponse response)
            throws HttpException
        {
            return new DiskSnapshotConsumer(response.getEntity(), true);
        }
    };


    public static final HttpAsyncResponseConsumerFactory<DiskSnapshot> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    public static final HttpAsyncResponseConsumerFactory<DiskSnapshot> OK_WITH_PATH =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            WITH_PATH);
}

