package ru.yandex.search.disk.indexer;

import java.io.IOException;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.QueryConstructor;

public class FilterDiskIndexerBatchEntry implements DiskIndexerBatchEntry {
    private static final long serialVersionUID = 0L;

    private final DiskIndexerBatchEntry batchEntry;

    public FilterDiskIndexerBatchEntry(
        final DiskIndexerBatchEntry batchEntry)
    {
        this.batchEntry = batchEntry;
    }

    @Override
    public boolean add(final DiskDocumentMeta doc) {
        return batchEntry.add(doc);
    }

    @Override
    public boolean isFull() {
        return batchEntry.isFull();
    }

    @Override
    public boolean isEmpty() {
        return batchEntry.isEmpty();
    }

    @Override
    public QueryConstructor uri(final DiskReindexContext context)
        throws BadRequestException
    {
        return batchEntry.uri(context);
    }

    @Override
    public String body() throws IOException {
        return batchEntry.body();
    }
}

