package ru.yandex.search.disk.indexer;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableURIConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableDiskIndexerConfig
    extends ImmutableHttpProxyConfig
    implements DiskIndexerConfig
{
    private final ImmutableURIConfig mpfsConfig;
    private final ImmutableHttpHostConfig producerConfig;
    private final ImmutableHttpHostConfig searchProxy;

    public ImmutableDiskIndexerConfig(final DiskIndexerConfig config)
        throws ConfigException
    {
        super(config);
        mpfsConfig = new ImmutableURIConfig(config.mpfsConfig());
        producerConfig = new ImmutableHttpHostConfig(config.producerConfig());
        if (config.searchProxy() != null) {
            searchProxy = new ImmutableHttpHostConfig(config.searchProxy());
        } else {
            searchProxy = null;
        }
    }

    @Override
    public ImmutableURIConfig mpfsConfig() {
        return mpfsConfig;
    }

    @Override
    public ImmutableHttpHostConfig producerConfig() {
        return producerConfig;
    }

    @Override
    public ImmutableHttpHostConfig searchProxy() {
        return searchProxy;
    }
}

