#!/bin/bash
set -exo pipefail
source disk-config-base.sh

export PUSHCLIENT_DEFAULT_TOPIC="/disk-search/disk-search-access-log"
export YT_ACCESS_LOG="/logs/producer_json_access_yt.log"
export PUSHCLIENT_DEFAULT_LOG_NAME=$YT_ACCESS_LOG

case "$NANNY_SERVICE_ID" in
  *_test)
    export PRODUCER_FULL_LOG_LEVEL="info"
    export PRODUCER_CONFIG="disk_producer_secure.conf"
    export SERVER_NAME="disk-producer-test.search.yandex.net"
#    export HTTPS_PORT="443"
    export SERVER_PORT=$BSCONFIG_IPORT
    export HTTPS_SERVER_PORT=$((BSCONFIG_IPORT + 2))
    ;;
  *_prod)
    export PRODUCER_FULL_LOG_LEVEL="off"
    export PRODUCER_CONFIG="disk_producer_secure.conf"
    export SERVER_NAME="disk-producer-secure.search.yandex.net"
    export SERVER_PORT=19922
    export HTTPS_SERVER_PORT="443"
    export PRODUCER_CONFIG="disk_producer_secure.conf"
    ;;
  *_prestable | *_mass)
    export PRODUCER_FULL_LOG_LEVEL="off"
    export PRODUCER_CONFIG="disk_producer.conf"
    ;;
esac

