#!/bin/bash
set -exo pipefail

source disk-config-base.sh

SEARCHMAP_PATH_TEMP=$SEARCHMAP_PATH.tmp
rm -f $SEARCHMAP_PATH_TEMP

# 1. callbacks and main map sm
curl -sf "$MOP_HOST/get-searchmap" > $SEARCHMAP_PATH_TEMP || exit 1
cat callbacks.txt >> $SEARCHMAP_PATH_TEMP


# 2. indexer sm
source disk_indexer_config.sh

./disk_indexer_searchmap_generator.sh > indexer_searchmap.txt

cat indexer_searchmap.txt >> $SEARCHMAP_PATH_TEMP

# 3. extra sm
if [ -x extra_searchmap.txt ]; then
	cat extra_searchmap.txt >> $SEARCHMAP_PATH_TEMP
fi

# 4. move generated sm to path
mv -f $SEARCHMAP_PATH_TEMP $SEARCHMAP_PATH

