#!/bin/sh
if [ -x gc_args.sh.overrides ]; then
	exec ./gc_args.sh.overrides
    exit 0;
fi

CPU_CORES_CORRECTION=${CPU_CORES_CORRECTION:-"0.2"}
if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
fi

if [ "$CPU_CORES" = "" ]; then
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["cpu_limit"]' | grep -Eo '[0-9\.]+' | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
fi

if [ "$MEM_LIMIT" != "" ]; then
    export MEMORY_LIMIT=$((MEM_LIMIT/100*80))
else
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.8)}')
fi

if [ "$MEMORY_LIMIT" = "0" ]; then
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["memory_guarantee"]' | awk '{print int($1*0.8)}')
fi


export GC_ARGS="
-XX:ActiveProcessorCount=7
-XX:+IgnoreUnrecognizedVMOptions
-XX:+HeapDumpOnOutOfMemoryError
-XX:HeapDumpPath=/cores
-XcompilationThreads1
-Xmx$MEMORY_LIMIT
-Xms1G
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseShenandoahGC
-XX:ConcGCThreads=1
-XX:ShenandoahGCMode=traversal
-XX:-ShenandoahAlwaysClearSoftRefs
-XX:ShenandoahAllocationThreshold=5
-XX:ShenandoahUncommitDelay=30000
-XX:ShenandoahGuaranteedGCInterval=30000
-XX:ShenandoahGarbageThreshold=10
-XX:+PrintCodeCache
-XX:ParallelGCThreads=$CPU_CORES
-XX:MaxHeapFreeRatio=20
-XX:MinHeapFreeRatio=10
-XX:+UnlockDiagnosticVMOptions
-XX:+PrintGCDateStamps
-XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=2M
-Xlog:gc*:/dev/shm/gclogs/gc.log
"