#!/bin/bash
set -xo pipefail

export TVM_API_HOST=https://tvm-api.yandex.net
export REVISION_FILE_PATH=revision_disk.txt
export SEARCHMAP_PATH=searchmap_disk.txt
export APE_TVM_CLIENT_ID=200
export LJINX_PORT=48477

case "$NANNY_SERVICE_ID" in
    *_test)
        export MAGE_URI=/api/v2.0/disktest/getmap
        export MAGE_PARAMS="&pformat=zkmtn"
        #
        export TVM_CLIENT_ID=186
        export TVM_CALLBACKS_CLIENT_ID=186
        export DISK_TVM_CLIENT_ID=2000411
        export DJFS_ALPUMS_TVM_CLIENT_ID=2017545
        export UNISTORAGE_TVM_CLIENT_ID=2000272
        export IPDD_TVM_CLIENT_ID=2000155
        export MPFS_TVM_CLIENT_ID="2000061"
	export BACKPACK_MDS_READER=http://storage-int.mdst.yandex.net:80
	export BACKPACK_MDS_WRITER=http://storage-int.mdst.yandex.net:1111
	export BACKPACK_MDS_TVM_ID=2000272
        #
        export DJFS_HOST=djfs-api-stable.qloud.dst.yandex.net
        export DJFS_ALBUM_HOST=djfs-albums-stable.qloud.dst.yandex.net
        export PRODUCER_GROUP=DISKSEARCH_PRODUCER_TEST
	export PRODUCERS_LIST=$(curl -s api.gencfg.yandex-team.ru/trunk/groups/$PRODUCER_GROUP/instances|jq '.instances[] | "\(.hostname):\(.port)"'|tr -d '"'|tr '\n' ','|sed 's/,$//')

        export PRODUCER_HOST=disk-producer-test.n.yandex-team.ru:80
        export PRODUCER_INDEXING_HOST=$PRODUCER_HOST
        export TIKAITE_SRW_HOST=tikaite.tst.ape.yandex.net
        export OCRAAS_SRW_HOST=ocraas-srw.tst.ape.yandex.net
        export IMAGEPARSER_SRW_HOST=imageparser-srw.tst.ape.yandex.net

        export PROXY_CACHE=localhost:$(LJINX_PORT)
	
        export LJINX_CACHE_TTL=1m
        export LOGROTATE_DAYS=1
        # watchdog settings
        export WATCHDOG_UID=3000441857
        export WATCHDOG_FILE_ID=559c00177ee1057edb153f0da7e69a38364ee39e4e3eb7f48ec67f3e8f545e80
        export MPFS_HOST=mpfs01d.dst.yandex.net

        export FACE_IN_QUEUE="face_in_queue_test"
        export FACE_OUT_QUEUE="face_out_queue_test"
        export FACE_KALI_ENABLED="true"
        export MOP_HOST="http://disk-search-mop-test.pers.yandex.net"
        ;;
    *_prestable|*_prod|*-prod|*_mass|*_qa)
        export MAGE_URI=/api/v1.0/disk/getmap
        export MAGE_PARAMS="&pformat=zkmtn"
        # tvm services client ids
        export TVM_CLIENT_ID=185
        export TVM_CALLBACKS_CLIENT_ID=2016443
        export DISK_TVM_CLIENT_ID=2000410
        export DJFS_ALPUMS_TVM_CLIENT_ID=2017547
        export UNISTORAGE_TVM_CLIENT_ID=2000273
        export IPDD_TVM_CLIENT_ID=2000154
        export MPFS_TVM_CLIENT_ID="127"
        export BACKPACK_MDS_READER=http://storage-int.mds.yandex.net:80
        export BACKPACK_MDS_WRITER=http://storage-int.mds.yandex.net:1111
        export BACKPACK_MDS_TVM_ID=2000273
        #
        export DJFS_HOST=djfs-api.qloud.disk.yandex.net
        export DJFS_ALBUM_HOST=djfs-albums.qloud.disk.yandex.net
        #export PRODUCER_GROUP=DISKSEARCH_PRODUCER_2
	#export PRODUCERS_LIST=$(curl -s api.gencfg.yandex-team.ru/trunk/groups/$PRODUCER_GROUP/instances|jq '.instances[] | "\(.hostname):\(.port)"'|tr -d '"'|tr '\n' ','|sed 's/,$//')
	#export PRODUCERS_LIST="disk-search-producer-yp-prod-1.sas.yp-c.yandex.net:80,disk-search-producer-yp-prod-2.sas.yp-c.yandex.net:80,disk-search-producer-yp-prod-3.sas.yp-c.yandex.net:80,disk-search-producer-yp-prod-1.man.yp-c.yandex.net:80,disk-search-producer-yp-prod-2.man.yp-c.yandex.net:80,disk-search-producer-yp-prod-3.man.yp-c.yandex.net:80,disk-search-producer-yp-prod-1.vla.yp-c.yandex.net:80,disk-search-producer-yp-prod-2.vla.yp-c.yandex.net:80,disk-search-producer-yp-prod-3.vla.yp-c.yandex.net:80"
        export PRODUCERS_LIST="disk-search-producer-main-prod-1.sas.yp-c.yandex.net:19922,disk-search-producer-main-prod-2.sas.yp-c.yandex.net:19922,disk-search-producer-main-prod-3.sas.yp-c.yandex.net:19922,disk-search-producer-main-prod-4.sas.yp-c.yandex.net:19922, disk-search-producer-main-prod-5.sas.yp-c.yandex.net:19922, disk-search-producer-main-prod-6.sas.yp-c.yandex.net:19922,disk-search-producer-main-prod-1.vla.yp-c.yandex.net:19922,disk-search-producer-main-prod-2.vla.yp-c.yandex.net:19922,disk-search-producer-main-prod-3.vla.yp-c.yandex.net:19922,disk-search-producer-main-prod-4.vla.yp-c.yandex.net:19922,disk-search-producer-main-prod-5.vla.yp-c.yandex.net:19922,disk-search-producer-main-prod-6.vla.yp-c.yandex.net:19922"
        export PRODUCER_HOST=disk-producer.search.yandex.net:19922
        # no PRODUCER_INDEXING_HOST, define it in proxy
        export TIKAITE_SRW_HOST=tikaite.ape.yandex.net
        export OCRAAS_SRW_HOST=ocraas.ape.yandex.net
        export IMAGEPARSER_SRW_HOST=imageparser.ape.yandex.net

        export PROXY_CACHE=ps-cache.mail.yandex.net

        export LJINX_CACHE_TTL=4w
        export LOGROTATE_DAYS=3
        # watchdog settings
        export WATCHDOG_UID=5598601
        export WATCHDOG_FILE_ID=632eddaf62a84ad0c30eb4aafcd7ab274599d433a3cf0b5dfe2b2a05280fa746
        export MPFS_HOST=mpfs.disk.yandex.net
        export FACE_IN_QUEUE="face_in_queue_prod"
        #export FACE_OUT_QUEUE="face_out_queue_prod"
        export FACE_OUT_QUEUE="disk_queue"
        export FACE_KALI_ENABLED="false"
        export MOP_HOST="http://disk-search-mop-prod.pers.yandex.net"
        ;;
esac

export PUSH_CLIENT_TVM_CLIENT_ID=$TVM_CLIENT_ID
export PUSH_CLIENT_TVM_SERVER_ID=2001059
export PUSH_CLIENT_TVM_SECRET=$SECRET

export OCRAAS_SRW_HOST_ESCAPED=$(echo $OCRAAS_SRW_HOST|sed 's/[.]/\\./g')
export IMAGEPARSER_SRW_HOST_ESCAPED=$(echo $IMAGEPARSER_SRW_HOST|sed 's/[.]/\\./g')

