package ru.yandex.search.disk;

import ru.yandex.function.GenericFunction;

public enum DiskFaceActionTypeParser implements GenericFunction<String, DiskFaceActionType, Exception> {
    INSTANCE;

    @Override
    public DiskFaceActionType apply(final String actionStr) throws Exception {
        return actionToFace(DiskIndexActionParser.NON_EMPTY.apply(actionStr));
    }

    public static DiskFaceActionType actionToFace(final DiskIndexAction action) {
        // for directories we will not receive callback, but just in case
        switch (action) {
            case MOVE_RESOURCE:
            case MOVE:
            case MKSYSDIR:
            case MKDIR:
            case LEAVE_FOLDER:
            case INVITE_ACTIVATED:
            case HARDLINK_COPY:
            case CLEAN_TRASH:
            case TRASH_DROP_ALL:
            case TRASH_DROP_ELEMENT:
            case SETPROP:
                return DiskFaceActionType.IGNORE;
            case RM:
            case TRASH_APPEND:
                return DiskFaceActionType.REMOVE;
            case TRASH_RESTORE:
                return DiskFaceActionType.RESTORE;
            default:
                return DiskFaceActionType.UPDATE;
        }
    }
}
